/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TraditionalWorkQueueMonitorEntry
extends MonitorEntry {
    static final String TRADITIONAL_WORK_QUEUE_MONITOR_OC = "ds-traditional-work-queue-monitor-entry";
    private static final String ATTR_AVERAGE_BACKLOG = "averageRequestBacklog";
    private static final String ATTR_CURRENT_BACKLOG = "currentRequestBacklog";
    private static final String ATTR_MAX_BACKLOG = "maxRequestBacklog";
    private static final String ATTR_REQUESTS_REJECTED = "requestsRejectedDueToQueueFull";
    private static final String ATTR_REQUESTS_SUBMITTED = "requestsSubmitted";
    private static final long serialVersionUID = 5254676890679281070L;
    private final Long averageBacklog = this.getLong("averageRequestBacklog");
    private final Long currentBacklog = this.getLong("currentRequestBacklog");
    private final Long maxBacklog = this.getLong("maxRequestBacklog");
    private final Long requestsRejected = this.getLong("requestsRejectedDueToQueueFull");
    private final Long requestsSubmitted = this.getLong("requestsSubmitted");

    public TraditionalWorkQueueMonitorEntry(Entry entry) {
        super(entry);
    }

    public Long getAverageBacklog() {
        return this.averageBacklog;
    }

    public Long getCurrentBacklog() {
        return this.currentBacklog;
    }

    public Long getMaxBacklog() {
        return this.maxBacklog;
    }

    public Long getRequestsRejectedDueToQueueFull() {
        return this.requestsRejected;
    }

    public Long getRequestsSubmitted() {
        return this.requestsSubmitted;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(10));
        if (this.requestsSubmitted != null) {
            TraditionalWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUESTS_SUBMITTED, MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_DISPNAME_REQUESTS_SUBMITTED.get(), MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_DESC_REQUESTS_SUBMITTED.get(), this.requestsSubmitted);
        }
        if (this.requestsRejected != null) {
            TraditionalWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUESTS_REJECTED, MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_DISPNAME_REQUESTS_REJECTED.get(), MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_DESC_REQUESTS_REJECTED.get(), this.requestsRejected);
        }
        if (this.currentBacklog != null) {
            TraditionalWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_BACKLOG, MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_DISPNAME_CURRENT_BACKLOG.get(), MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_DESC_CURRENT_BACKLOG.get(), this.currentBacklog);
        }
        if (this.averageBacklog != null) {
            TraditionalWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_AVERAGE_BACKLOG, MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_DISPNAME_AVERAGE_BACKLOG.get(), MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_DESC_AVERAGE_BACKLOG.get(), this.averageBacklog);
        }
        if (this.maxBacklog != null) {
            TraditionalWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_BACKLOG, MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_DISPNAME_MAX_BACKLOG.get(), MonitorMessages.INFO_TRADITIONAL_WORK_QUEUE_DESC_MAX_BACKLOG.get(), this.maxBacklog);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

