/*
 * Decompiled with CFR 0.152.
 */
package netsync;

import java.io.Console;
import java.util.Hashtable;
import java.util.Scanner;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

@SpringBootApplication
public class LDAP {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        String ldapUrl = "ldap://fdv-dc-2.frisco.friscotexas.gov:389";
        System.out.println("provider url :" + ldapUrl);
        String baseDN = "dc=frisco,dc=friscotexas,dc=gov";
        System.out.println("baseDN :" + baseDN);
        System.out.println("Please enter the  user name ");
        String ldapUserName = sc.nextLine();
        Console console = System.console();
        char[] passwordString = console.readPassword("Enter your secret password for user '" + ldapUserName + "': ", new Object[0]);
        String ldapPassword = new String(passwordString);
        System.out.println("Please enter the username to lookup :");
        String userToLookup = sc.nextLine();
        Hashtable<String, String> environment = new Hashtable<String, String>();
        String bindPrincipal = userToLookup;
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", ldapUrl);
        environment.put("java.naming.security.authentication", "simple");
        environment.put("java.naming.security.principal", ldapUserName);
        environment.put("java.naming.security.credentials", ldapPassword);
        environment.put("java.naming.factory.object", DefaultDirObjectFactory.class.getName());
        try {
            InitialDirContext context = new InitialDirContext(environment);
            String FILTER = "(&(objectClass=person)(sAMAccountName={0}))";
            String[] attrIDs = new String[]{"sn", "givenName"};
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            DirContextOperations results = SpringSecurityLdapTemplate.searchForSingleEntryInternal((DirContext)context, (SearchControls)searchControls, (String)baseDN, (String)FILTER, (Object[])new Object[]{bindPrincipal, userToLookup});
            System.out.println("user " + results);
        }
        catch (AuthenticationNotSupportedException exception) {
            System.out.println("The authentication is not supported by the server");
            exception.printStackTrace();
        }
        catch (AuthenticationException exception) {
            System.out.println("Incorrect password or username");
            exception.printStackTrace();
        }
        catch (NamingException exception) {
            System.out.println("Error when trying to create the context");
            exception.printStackTrace();
        }
    }
}

