window.addEventListener('load', () => {
  drawChannels();
  registerSW();
  window.addEventListener('keyup', Highlight);
});

async function login(){
  const loginRespayload = await fetch('https://uat.go2alto.com/api/device/sync' , {
    method: 'POST',
    headers: {
      'Accept': 'application/json',
      'Content-Type': 'application/json'
    },
    body: JSON.stringify({device_mac: '900EB333CF29'})
  });
  const  loginRes = await loginRespayload.json();
  console.log('sdf');
  if(loginRes.data?.token){
    localStorage.setItem('token' , loginRes.data?.token);
    return true;
  }
  return false;
}

async function getChannels() {
  if(!localStorage.getItem('token')){
    if(!(await login())){
      return []; //something went wrong in authentication
    }
    return await (getChannels());
  }
  const token = localStorage.getItem('token');
  const channlesResPayload = await fetch('https://uat.go2alto.com/api/app-profile' , {
      method: 'GET',
      headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
        'Authorization': "Bearer "+token
      },
    });
    const channlesRes = await channlesResPayload.json();
    if(channlesRes.message == "Unauthenticated"){
      if(!(await login())){
        return []; //something went wrong in authentication
      }
      return await getChannels();
    }
    console.log(channlesRes);
    if(channlesRes.error_code == 0){
      return channlesRes.data.mode.Multichannel[0].channels.map(x => ({name:x.name , url:`./video.html?video=${x.url}&poster=${x.image}` , image:x.image}));
    }
    return [];
}

async function drawChannels(){
  // const channels = [
  //   {
  //     url:'./video.html?video=https://pbmtvlive-19a58.kxcdn.com/pbmtv/live_abr/playlist.m3u8&poster=./images/bt-tv.png',
  //     image:'./images/bt-tv.png',
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/discovery-on-de.png',
  //     image:'./images/discovery-on-de.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/disney-plus.png',
  //     image:'./images/disney-plus.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/espn-plus.png',
  //     image:'./images/espn-plus.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/hbo-max.png',
  //     image:'./images/hbo-max.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/hbo-max-alt.png',
  //     image:'./images/hbo-max-alt.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/hulu.png',
  //     image:'./images/hulu.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/bt-tv.png',
  //     image:'./images/bt-tv.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/discovery-on-de.png',
  //     image:'./images/discovery-on-de.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/disney-plus.png',
  //     image:'./images/disney-plus.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/espn-plus.png',
  //     image:'./images/espn-plus.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/hbo-max.png',
  //     image:'./images/hbo-max.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/hbo-max-alt.png',
  //     image:'./images/hbo-max-alt.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/hulu.png',
  //     image:'./images/hulu.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/bt-tv.png',
  //     image:'./images/bt-tv.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/discovery-on-de.png',
  //     image:'./images/discovery-on-de.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/disney-plus.png',
  //     image:'./images/disney-plus.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/espn-plus.png',
  //     image:'./images/espn-plus.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/hbo-max.png',
  //     image:'./images/hbo-max.png'
  //   },
  //   {
  //     url:'./video.html?video=https://cdn.flowplayer.com/a30bd6bc-f98b-47bc-abf5-97633d4faea0/hls/de3f6ca7-2db3-4689-8160-0f574a5996ad/playlist.m3u8&poster=./images/hbo-max-alt.png',
  //     image:'./images/hbo-max-alt.png'
  //   },
  // ]
  const channels = await getChannels();
  const channelCards = document.querySelector('main > .cards');

  channels.forEach((channel , index) => {

    const el = document.createElement('div');
    el.classList.add('card');
    let content = `
    <a href="${channel.url}">
      <div class="image">
        <img src="${channel.image}" />
      </div>
    </a>
    `
    el.innerHTML = content;
   
    if(index == 0){
      el.classList.add('active');
    }

    channelCards.appendChild(el);
  });
}

async function registerSW() {
  if ('serviceWorker' in navigator) {
    try {
      await navigator.serviceWorker.register('./sw.js');
    } catch (e) {
      console.log(`SW registration failed`);
    }
  }
}

async function Highlight(e){
  let code = e.keyCode || e.which;
  let header = document.querySelector("header");
  let activeCard = document.querySelector(".card.active");
  let CardsTop = parseInt(getComputedStyle(document.querySelector(".cards")).paddingTop)
  let CardsBottom = parseInt(getComputedStyle(document.querySelector(".cards")).paddingBottom)
  switch (code) {
    case 37:  //left
      if(activeCard.previousElementSibling != undefined){
        activeCard.classList.remove('active');
        activeCard.previousElementSibling.classList.add('active')
        document.querySelector("main").scrollTop = (activeCard.previousElementSibling.offsetTop - header.clientHeight - CardsTop - CardsBottom)
      }
      break;
    case 38:  //up
    let topCard = await CalculateTopElement();
    if(topCard != undefined){
      activeCard.classList.remove('active');
      topCard.classList.add('active')
      document.querySelector("main").scrollTop = (topCard.offsetTop - header.clientHeight - CardsTop - CardsBottom)
    }
      break;
    case 39:  //right
      if(activeCard.nextElementSibling != undefined){
        activeCard.classList.remove('active');
        activeCard.nextElementSibling.classList.add('active')
        document.querySelector("main").scrollTop = (activeCard.nextElementSibling.offsetTop - header.clientHeight - CardsTop - CardsBottom)
      }
      break;
    case 40:  //down
      let bottomCard = await CalculateBottomElement();
      if(bottomCard != undefined){
        activeCard.classList.remove('active');
        bottomCard.classList.add('active')
        document.querySelector("main").scrollTop = (bottomCard.offsetTop - header.clientHeight - CardsTop - CardsBottom)
      }
      break;
    case 13:  //enter
        
        activeCard.querySelector('a').click()
      break;
    default:
      break;
  }
}

async function CalculateBottomElement(){
  let data = await GetCardInRowAndCurrentActiveCard();
  return data.cards[data.activeCardIndex + data.CardInRow]
}

async function CalculateTopElement(){
  let data = await GetCardInRowAndCurrentActiveCard();
  return data.cards[data.activeCardIndex - data.CardInRow]
}

async function GetCardInRowAndCurrentActiveCard(){
  let cards = document.querySelectorAll(".card");
  if(cards.length == 0){
    return undefined;
  }
  let cardWidth = cards[0].clientWidth;
  let ContainerCardWidth = cards[0].parentElement.clientWidth;
  let CardInRow = Math.floor(ContainerCardWidth / cardWidth);
  
  let activeCardIndex = 0;

  for (let index = 0; index < cards.length; index++) {
    if(cards[index].classList.contains('active')){
      activeCardIndex = index;
      break;
    }
  }
  return {
    cards,
    CardInRow,
    activeCardIndex
  }
}
