/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.dao;

import com.netsync.smp.domain.informix.InformixPrompt;
import com.netsync.smp.domain.informix.InformixTriggerApp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class InformixRepository {
    protected JdbcTemplate jdbc_cra;
    protected JdbcTemplate jdbc_cra_repository;

    @Autowired
    public InformixRepository(@Qualifier(value="informixJdbcTemplateCra") JdbcTemplate jdbc_cra, @Qualifier(value="informixJdbcTemplateCraRepository") JdbcTemplate jdbc_cra_repository) {
        this.jdbc_cra = jdbc_cra;
        this.jdbc_cra_repository = jdbc_cra_repository;
    }

    public List<InformixTriggerApp> findAppsTriggers() {
        String sql = "SELECT triggername, applicationname FROM crstrigger WHERE active AND triggerenabled AND triggertype = 'Cisco JTAPI Trigger'";
        List results = this.jdbc_cra.queryForList(sql);
        ArrayList<InformixTriggerApp> triggerApps = new ArrayList<InformixTriggerApp>();
        for (Map element : results) {
            triggerApps.add(new InformixTriggerApp(element.get("triggername").toString(), element.get("applicationname").toString()));
        }
        return triggerApps;
    }

    public void clearAppsTriggers() {
    }

    public List<InformixPrompt> findPrompts() {
        String sql = "SELECT filename AS promptName, foldername AS localeName FROM promptsfiletbl INNER JOIN promptsfoldertbl ON promptsfiletbl.parentfolderid = promptsfoldertbl.folderid";
        List results = this.jdbc_cra_repository.queryForList(sql);
        ArrayList<InformixPrompt> triggerApps = new ArrayList<InformixPrompt>();
        for (Map element : results) {
            triggerApps.add(new InformixPrompt(element.get("promptName").toString(), element.get("localeName").toString()));
        }
        return triggerApps;
    }

    public void clearPrompts() {
    }
}

