/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.domain;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.netsync.smp.web.config.fasterxml.JsonSerializerInstant;
import java.beans.ConstructorProperties;
import java.time.Instant;
import lombok.NonNull;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="AuditTrail")
public class AuditEntry {
    @Id
    private String id;
    @Indexed
    @JsonSerialize(using=JsonSerializerInstant.class)
    @NonNull
    private Instant timestamp;
    @NonNull
    private String userId;
    @NonNull
    private boolean isAdminAtLogTime;
    @NonNull
    private String logMessage;

    public String getId() {
        return this.id;
    }

    @NonNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    @NonNull
    public boolean isAdminAtLogTime() {
        return this.isAdminAtLogTime;
    }

    @NonNull
    public String getLogMessage() {
        return this.logMessage;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTimestamp(@NonNull Instant timestamp) {
        if (timestamp == null) {
            throw new NullPointerException("timestamp");
        }
        this.timestamp = timestamp;
    }

    public void setUserId(@NonNull String userId) {
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        this.userId = userId;
    }

    public void setAdminAtLogTime(@NonNull boolean isAdminAtLogTime) {
        this.isAdminAtLogTime = isAdminAtLogTime;
    }

    public void setLogMessage(@NonNull String logMessage) {
        if (logMessage == null) {
            throw new NullPointerException("logMessage");
        }
        this.logMessage = logMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditEntry)) {
            return false;
        }
        AuditEntry other = (AuditEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        if (this.isAdminAtLogTime() != other.isAdminAtLogTime()) {
            return false;
        }
        String this$logMessage = this.getLogMessage();
        String other$logMessage = other.getLogMessage();
        return !(this$logMessage == null ? other$logMessage != null : !this$logMessage.equals(other$logMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 0 : ((Object)$timestamp).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 0 : $userId.hashCode());
        result = result * 59 + (this.isAdminAtLogTime() ? 79 : 97);
        String $logMessage = this.getLogMessage();
        result = result * 59 + ($logMessage == null ? 0 : $logMessage.hashCode());
        return result;
    }

    public String toString() {
        return "AuditEntry(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", userId=" + this.getUserId() + ", isAdminAtLogTime=" + this.isAdminAtLogTime() + ", logMessage=" + this.getLogMessage() + ")";
    }

    public AuditEntry() {
    }

    @ConstructorProperties(value={"timestamp", "userId", "isAdminAtLogTime", "logMessage"})
    public AuditEntry(@NonNull Instant timestamp, @NonNull String userId, @NonNull boolean isAdminAtLogTime, @NonNull String logMessage) {
        if (timestamp == null) {
            throw new NullPointerException("timestamp");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (logMessage == null) {
            throw new NullPointerException("logMessage");
        }
        this.timestamp = timestamp;
        this.userId = userId;
        this.isAdminAtLogTime = isAdminAtLogTime;
        this.logMessage = logMessage;
    }
}

