/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.netsync.smp.domain.HolidayPromptGroup;
import com.netsync.smp.domain.OpenCloseHours;
import com.netsync.smp.web.config.fasterxml.JsonDeserializerLocalDate;
import com.netsync.smp.web.config.fasterxml.JsonSerializerLocalDate;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.lang.UsesJava8;

@Document(collection="HolidayRules")
@UsesJava8
public class HolidayRule {
    @Id
    private String id;
    @Indexed(unique=true)
    @NonNull
    private String name;
    @NonNull
    private OpenCloseHours openCloseHours;
    @NonNull
    private String rule;
    @JsonProperty(value="isRecurring")
    private boolean isRecurring;
    @JsonProperty(value="isAdvanced")
    private boolean isAdvanced;
    @JsonProperty(value="isQuarterly")
    private boolean isQuarterly;
    @JsonSerialize(using=JsonSerializerLocalDate.class)
    @JsonDeserialize(using=JsonDeserializerLocalDate.class)
    @NonNull
    private LocalDate dtstart;
    @JsonDeserialize(as=HashMap.class)
    @NonNull
    private Map<Locale, HolidayPromptGroup> holidayPrompts;

    public String getId() {
        return this.id;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public OpenCloseHours getOpenCloseHours() {
        return this.openCloseHours;
    }

    @NonNull
    public String getRule() {
        return this.rule;
    }

    public boolean isRecurring() {
        return this.isRecurring;
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public boolean isQuarterly() {
        return this.isQuarterly;
    }

    @NonNull
    public LocalDate getDtstart() {
        return this.dtstart;
    }

    @NonNull
    public Map<Locale, HolidayPromptGroup> getHolidayPrompts() {
        return this.holidayPrompts;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    public void setOpenCloseHours(@NonNull OpenCloseHours openCloseHours) {
        if (openCloseHours == null) {
            throw new NullPointerException("openCloseHours");
        }
        this.openCloseHours = openCloseHours;
    }

    public void setRule(@NonNull String rule) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        this.rule = rule;
    }

    public void setRecurring(boolean isRecurring) {
        this.isRecurring = isRecurring;
    }

    public void setAdvanced(boolean isAdvanced) {
        this.isAdvanced = isAdvanced;
    }

    public void setQuarterly(boolean isQuarterly) {
        this.isQuarterly = isQuarterly;
    }

    public void setDtstart(@NonNull LocalDate dtstart) {
        if (dtstart == null) {
            throw new NullPointerException("dtstart");
        }
        this.dtstart = dtstart;
    }

    public void setHolidayPrompts(@NonNull Map<Locale, HolidayPromptGroup> holidayPrompts) {
        if (holidayPrompts == null) {
            throw new NullPointerException("holidayPrompts");
        }
        this.holidayPrompts = holidayPrompts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HolidayRule)) {
            return false;
        }
        HolidayRule other = (HolidayRule)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        OpenCloseHours this$openCloseHours = this.getOpenCloseHours();
        OpenCloseHours other$openCloseHours = other.getOpenCloseHours();
        if (this$openCloseHours == null ? other$openCloseHours != null : !this$openCloseHours.equals(other$openCloseHours)) {
            return false;
        }
        String this$rule = this.getRule();
        String other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        if (this.isRecurring() != other.isRecurring()) {
            return false;
        }
        if (this.isAdvanced() != other.isAdvanced()) {
            return false;
        }
        if (this.isQuarterly() != other.isQuarterly()) {
            return false;
        }
        LocalDate this$dtstart = this.getDtstart();
        LocalDate other$dtstart = other.getDtstart();
        if (this$dtstart == null ? other$dtstart != null : !((Object)this$dtstart).equals(other$dtstart)) {
            return false;
        }
        Map this$holidayPrompts = this.getHolidayPrompts();
        Map other$holidayPrompts = other.getHolidayPrompts();
        return !(this$holidayPrompts == null ? other$holidayPrompts != null : !((Object)this$holidayPrompts).equals(other$holidayPrompts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HolidayRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        OpenCloseHours $openCloseHours = this.getOpenCloseHours();
        result = result * 59 + ($openCloseHours == null ? 0 : $openCloseHours.hashCode());
        String $rule = this.getRule();
        result = result * 59 + ($rule == null ? 0 : $rule.hashCode());
        result = result * 59 + (this.isRecurring() ? 79 : 97);
        result = result * 59 + (this.isAdvanced() ? 79 : 97);
        result = result * 59 + (this.isQuarterly() ? 79 : 97);
        LocalDate $dtstart = this.getDtstart();
        result = result * 59 + ($dtstart == null ? 0 : ((Object)$dtstart).hashCode());
        Map $holidayPrompts = this.getHolidayPrompts();
        result = result * 59 + ($holidayPrompts == null ? 0 : ((Object)$holidayPrompts).hashCode());
        return result;
    }

    public String toString() {
        return "HolidayRule(id=" + this.getId() + ", name=" + this.getName() + ", openCloseHours=" + this.getOpenCloseHours() + ", rule=" + this.getRule() + ", isRecurring=" + this.isRecurring() + ", isAdvanced=" + this.isAdvanced() + ", isQuarterly=" + this.isQuarterly() + ", dtstart=" + this.getDtstart() + ", holidayPrompts=" + this.getHolidayPrompts() + ")";
    }

    public HolidayRule() {
    }

    @ConstructorProperties(value={"name", "openCloseHours", "rule", "dtstart", "holidayPrompts"})
    public HolidayRule(@NonNull String name, @NonNull OpenCloseHours openCloseHours, @NonNull String rule, @NonNull LocalDate dtstart, @NonNull Map<Locale, HolidayPromptGroup> holidayPrompts) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (openCloseHours == null) {
            throw new NullPointerException("openCloseHours");
        }
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        if (dtstart == null) {
            throw new NullPointerException("dtstart");
        }
        if (holidayPrompts == null) {
            throw new NullPointerException("holidayPrompts");
        }
        this.name = name;
        this.openCloseHours = openCloseHours;
        this.rule = rule;
        this.dtstart = dtstart;
        this.holidayPrompts = holidayPrompts;
    }
}

