/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netsync.smp.domain.HolidaySchema;
import com.netsync.smp.domain.LocationOrGroupTag;
import com.netsync.smp.domain.OpenCloseHours;
import com.netsync.smp.domain.StandardPromptGroup;
import java.beans.ConstructorProperties;
import java.time.DayOfWeek;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="UccxApplications")
public class UccxApplication {
    @Id
    protected String id;
    @Indexed(unique=true)
    @NonNull
    protected String name;
    @Indexed(unique=true)
    @NonNull
    protected String trigger;
    @JsonProperty(value="isEmergencyClosed")
    @NonNull
    protected boolean isEmergencyClosed;
    @DBRef
    private HolidaySchema holidaySchema;
    @DBRef
    @JsonDeserialize(as=HashSet.class)
    @NonNull
    private Set<LocationOrGroupTag> tags;
    @JsonDeserialize(as=HashMap.class)
    @NonNull
    private Map<DayOfWeek, OpenCloseHours> openCloseHours;
    @JsonDeserialize(as=HashMap.class)
    @NonNull
    private Map<Locale, StandardPromptGroup> standardPrompts;

    public String getId() {
        return this.id;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getTrigger() {
        return this.trigger;
    }

    @NonNull
    public boolean isEmergencyClosed() {
        return this.isEmergencyClosed;
    }

    public HolidaySchema getHolidaySchema() {
        return this.holidaySchema;
    }

    @NonNull
    public Set<LocationOrGroupTag> getTags() {
        return this.tags;
    }

    @NonNull
    public Map<DayOfWeek, OpenCloseHours> getOpenCloseHours() {
        return this.openCloseHours;
    }

    @NonNull
    public Map<Locale, StandardPromptGroup> getStandardPrompts() {
        return this.standardPrompts;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    public void setTrigger(@NonNull String trigger) {
        if (trigger == null) {
            throw new NullPointerException("trigger");
        }
        this.trigger = trigger;
    }

    public void setEmergencyClosed(@NonNull boolean isEmergencyClosed) {
        this.isEmergencyClosed = isEmergencyClosed;
    }

    public void setHolidaySchema(HolidaySchema holidaySchema) {
        this.holidaySchema = holidaySchema;
    }

    public void setTags(@NonNull Set<LocationOrGroupTag> tags) {
        if (tags == null) {
            throw new NullPointerException("tags");
        }
        this.tags = tags;
    }

    public void setOpenCloseHours(@NonNull Map<DayOfWeek, OpenCloseHours> openCloseHours) {
        if (openCloseHours == null) {
            throw new NullPointerException("openCloseHours");
        }
        this.openCloseHours = openCloseHours;
    }

    public void setStandardPrompts(@NonNull Map<Locale, StandardPromptGroup> standardPrompts) {
        if (standardPrompts == null) {
            throw new NullPointerException("standardPrompts");
        }
        this.standardPrompts = standardPrompts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UccxApplication)) {
            return false;
        }
        UccxApplication other = (UccxApplication)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$trigger = this.getTrigger();
        String other$trigger = other.getTrigger();
        if (this$trigger == null ? other$trigger != null : !this$trigger.equals(other$trigger)) {
            return false;
        }
        if (this.isEmergencyClosed() != other.isEmergencyClosed()) {
            return false;
        }
        HolidaySchema this$holidaySchema = this.getHolidaySchema();
        HolidaySchema other$holidaySchema = other.getHolidaySchema();
        if (this$holidaySchema == null ? other$holidaySchema != null : !this$holidaySchema.equals(other$holidaySchema)) {
            return false;
        }
        Set this$tags = this.getTags();
        Set other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map this$openCloseHours = this.getOpenCloseHours();
        Map other$openCloseHours = other.getOpenCloseHours();
        if (this$openCloseHours == null ? other$openCloseHours != null : !((Object)this$openCloseHours).equals(other$openCloseHours)) {
            return false;
        }
        Map this$standardPrompts = this.getStandardPrompts();
        Map other$standardPrompts = other.getStandardPrompts();
        return !(this$standardPrompts == null ? other$standardPrompts != null : !((Object)this$standardPrompts).equals(other$standardPrompts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UccxApplication;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        String $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 0 : $trigger.hashCode());
        result = result * 59 + (this.isEmergencyClosed() ? 79 : 97);
        HolidaySchema $holidaySchema = this.getHolidaySchema();
        result = result * 59 + ($holidaySchema == null ? 0 : $holidaySchema.hashCode());
        Set $tags = this.getTags();
        result = result * 59 + ($tags == null ? 0 : ((Object)$tags).hashCode());
        Map $openCloseHours = this.getOpenCloseHours();
        result = result * 59 + ($openCloseHours == null ? 0 : ((Object)$openCloseHours).hashCode());
        Map $standardPrompts = this.getStandardPrompts();
        result = result * 59 + ($standardPrompts == null ? 0 : ((Object)$standardPrompts).hashCode());
        return result;
    }

    public String toString() {
        return "UccxApplication(id=" + this.getId() + ", name=" + this.getName() + ", trigger=" + this.getTrigger() + ", isEmergencyClosed=" + this.isEmergencyClosed() + ", holidaySchema=" + this.getHolidaySchema() + ", tags=" + this.getTags() + ", openCloseHours=" + this.getOpenCloseHours() + ", standardPrompts=" + this.getStandardPrompts() + ")";
    }

    public UccxApplication() {
    }

    @ConstructorProperties(value={"name", "trigger", "isEmergencyClosed", "tags", "openCloseHours", "standardPrompts"})
    public UccxApplication(@NonNull String name, @NonNull String trigger, @NonNull boolean isEmergencyClosed, @NonNull Set<LocationOrGroupTag> tags, @NonNull Map<DayOfWeek, OpenCloseHours> openCloseHours, @NonNull Map<Locale, StandardPromptGroup> standardPrompts) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (trigger == null) {
            throw new NullPointerException("trigger");
        }
        if (tags == null) {
            throw new NullPointerException("tags");
        }
        if (openCloseHours == null) {
            throw new NullPointerException("openCloseHours");
        }
        if (standardPrompts == null) {
            throw new NullPointerException("standardPrompts");
        }
        this.name = name;
        this.trigger = trigger;
        this.isEmergencyClosed = isEmergencyClosed;
        this.tags = tags;
        this.openCloseHours = openCloseHours;
        this.standardPrompts = standardPrompts;
    }
}

