/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netsync.smp.domain.HashedPassword;
import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="Users")
public class User {
    @Id
    private String id;
    @Indexed(unique=true)
    @NonNull
    protected String userId;
    @JsonIgnore
    protected HashedPassword hashedPassword;
    @Indexed
    @JsonProperty(value="isAdmin")
    @NonNull
    protected boolean isAdmin;
    @Indexed
    @JsonProperty(value="isLdap")
    @NonNull
    protected boolean isLdap;

    public String getId() {
        return this.id;
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public HashedPassword getHashedPassword() {
        return this.hashedPassword;
    }

    @NonNull
    public boolean isAdmin() {
        return this.isAdmin;
    }

    @NonNull
    public boolean isLdap() {
        return this.isLdap;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUserId(@NonNull String userId) {
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        this.userId = userId;
    }

    public void setHashedPassword(HashedPassword hashedPassword) {
        this.hashedPassword = hashedPassword;
    }

    public void setAdmin(@NonNull boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setLdap(@NonNull boolean isLdap) {
        this.isLdap = isLdap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        HashedPassword this$hashedPassword = this.getHashedPassword();
        HashedPassword other$hashedPassword = other.getHashedPassword();
        if (this$hashedPassword == null ? other$hashedPassword != null : !this$hashedPassword.equals(other$hashedPassword)) {
            return false;
        }
        if (this.isAdmin() != other.isAdmin()) {
            return false;
        }
        return this.isLdap() == other.isLdap();
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 0 : $userId.hashCode());
        HashedPassword $hashedPassword = this.getHashedPassword();
        result = result * 59 + ($hashedPassword == null ? 0 : $hashedPassword.hashCode());
        result = result * 59 + (this.isAdmin() ? 79 : 97);
        result = result * 59 + (this.isLdap() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "User(id=" + this.getId() + ", userId=" + this.getUserId() + ", hashedPassword=" + this.getHashedPassword() + ", isAdmin=" + this.isAdmin() + ", isLdap=" + this.isLdap() + ")";
    }

    public User() {
    }

    @ConstructorProperties(value={"userId", "isAdmin", "isLdap"})
    public User(@NonNull String userId, @NonNull boolean isAdmin, @NonNull boolean isLdap) {
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        this.userId = userId;
        this.isAdmin = isAdmin;
        this.isLdap = isLdap;
    }
}

