/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.dao.ApplicationRepository;
import com.netsync.smp.domain.ApplicationPermissionLevel;
import com.netsync.smp.domain.ApplicationUserPermission;
import com.netsync.smp.domain.AuditTrailActions;
import com.netsync.smp.domain.AuditTrailObjectTypes;
import com.netsync.smp.domain.LocationOrGroupTag;
import com.netsync.smp.domain.UccxApplication;
import com.netsync.smp.domain.User;
import com.netsync.smp.domain.frontend.SmpDatabaseId;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.ApplicationUserPermissionsDataFacade;
import com.netsync.smp.logic.AuditTrailDataFacade;
import com.netsync.smp.logic.UserDataFacade;
import com.netsync.smp.web.security.CurrentUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationDataFacade {
    protected ApplicationRepository repo;
    protected ApplicationUserPermissionsDataFacade aupFacade;
    protected UserDataFacade userFacade;
    protected AuditTrailDataFacade auditFacade;

    @Autowired
    public ApplicationDataFacade(ApplicationRepository repo, ApplicationUserPermissionsDataFacade aupFacade, UserDataFacade userFacade, AuditTrailDataFacade auditFacade) {
        this.repo = repo;
        this.aupFacade = aupFacade;
        this.userFacade = userFacade;
        this.auditFacade = auditFacade;
    }

    protected List<ApplicationUserPermission> buildPermissions() {
        User user = CurrentUser.get();
        if (CurrentUser.isAdmin()) {
            ArrayList<ApplicationUserPermission> allPermissions = new ArrayList<ApplicationUserPermission>();
            List allApps = this.repo.findAll();
            if (null == allApps) {
                return allPermissions;
            }
            allApps.forEach(app -> allPermissions.add(new ApplicationUserPermission(app, user, ApplicationPermissionLevel.Edit)));
            return allPermissions;
        }
        return this.aupFacade.getAllAppsForUserId(user.getId());
    }

    public List<ApplicationUserPermission> findAll() {
        return this.buildPermissions();
    }

    public List<ApplicationUserPermission> findUsers(String id) throws SmpNotFoundException {
        ArrayList<ApplicationUserPermission> perms = new ArrayList<ApplicationUserPermission>();
        UccxApplication app = (UccxApplication)this.repo.findOne((Serializable)((Object)id));
        if (null == app) {
            throw new SmpNotFoundException("id", "applications");
        }
        List users = this.userFacade.findAll();
        for (User user : users) {
            if (user.isAdmin()) {
                perms.add(new ApplicationUserPermission(app, user, ApplicationPermissionLevel.Edit));
                continue;
            }
            ApplicationUserPermission perm = this.aupFacade.getPermissionsForUserAndApp(user.getId(), app.getId());
            if (perm == null) {
                perms.add(new ApplicationUserPermission(app, user, ApplicationPermissionLevel.None));
                continue;
            }
            perms.add(perm);
        }
        return perms;
    }

    public List<ApplicationUserPermission> saveUsers(String id, List<ApplicationUserPermission> perms) throws SmpNotFoundException, SmpNotAuthorizedException {
        UccxApplication app = (UccxApplication)this.repo.findOne((Serializable)((Object)id));
        if (null == app) {
            throw new SmpNotFoundException("id", "applications");
        }
        User user = CurrentUser.get();
        if (!user.isAdmin() && !this.aupFacade.getCanEditApplication(user.getId(), app.getId())) {
            throw new SmpNotAuthorizedException("update applications");
        }
        ArrayList<ApplicationUserPermission> permsToSave = new ArrayList<ApplicationUserPermission>();
        ArrayList<ApplicationUserPermission> permsToDelete = new ArrayList<ApplicationUserPermission>();
        for (ApplicationUserPermission perm : perms) {
            User dbUser = this.userFacade.findOneById(perm.getUser().getId());
            if (dbUser.isAdmin()) continue;
            if (perm.getPermission() == ApplicationPermissionLevel.None && perm.getId() != null) {
                permsToDelete.add(perm);
                continue;
            }
            if (perm.getPermission() == null) continue;
            permsToSave.add(perm);
        }
        for (ApplicationUserPermission perm : permsToDelete) {
            this.aupFacade.removeById(perm.getId());
        }
        for (ApplicationUserPermission perm : permsToSave) {
            if (perm.getId() == null) {
                this.aupFacade.create(perm);
                continue;
            }
            this.aupFacade.save(perm);
        }
        return this.findUsers(id);
    }

    public Set<LocationOrGroupTag> getAllUniqueTagsInUse() {
        HashSet<LocationOrGroupTag> allUniqueTags = new HashSet<LocationOrGroupTag>();
        this.findAll().stream().collect(Collectors.groupingBy(ApplicationUserPermission::getApplication)).keySet().stream().collect(Collectors.groupingBy(UccxApplication::getTags)).keySet().forEach(subSet -> allUniqueTags.addAll((Collection<LocationOrGroupTag>)subSet));
        return allUniqueTags;
    }

    public ApplicationUserPermission findOneById(String id) throws SmpNotFoundException {
        UccxApplication app = (UccxApplication)this.repo.findOne((Serializable)((Object)id));
        if (null == app) {
            throw new SmpNotFoundException("id", "applications");
        }
        User user = CurrentUser.get();
        if (user.isAdmin()) {
            return new ApplicationUserPermission(app, user, ApplicationPermissionLevel.Edit);
        }
        return this.aupFacade.getPermissionsForUserAndApp(user.getId(), app.getId());
    }

    public SmpDatabaseId create(@NonNull UccxApplication app) {
        if (app == null) {
            throw new NullPointerException("app");
        }
        this.auditFacade.LogAction(AuditTrailActions.Create, AuditTrailObjectTypes.Application, app.getName());
        return new SmpDatabaseId(this.repo.insert(app).getId(), "application");
    }

    public SmpDatabaseId update(@NonNull String id, @NonNull UccxApplication app) throws SmpIllegalDataException, SmpNotAuthorizedException {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (app == null) {
            throw new NullPointerException("app");
        }
        if (id.isEmpty()) {
            throw new SmpIllegalDataException("ID must be valid to create");
        }
        if (!id.equals(app.getId())) {
            throw new SmpIllegalDataException("URL ID must match payload ID");
        }
        User user = CurrentUser.get();
        if (!user.isAdmin() && !this.aupFacade.getCanEditApplication(user.getId(), app.getId())) {
            throw new SmpNotAuthorizedException("update applications");
        }
        this.auditFacade.LogAction(AuditTrailActions.Update, AuditTrailObjectTypes.Application, app.getName());
        return new SmpDatabaseId(this.repo.save(app).getId(), "application");
    }

    public boolean isHolidaySchemaUsed(String holidaySchemaId) {
        List all = this.repo.findAll();
        for (UccxApplication application : all) {
            if (application.getHolidaySchema() == null || !application.getHolidaySchema().getId().equals(holidaySchemaId)) continue;
            return true;
        }
        return false;
    }

    public void delete(String id) throws SmpNotAuthorizedException, SmpNotFoundException {
        if (!CurrentUser.isAdmin()) {
            throw new SmpNotAuthorizedException("delete applications");
        }
        UccxApplication app = this.repo.findOneById(id);
        if (null == app) {
            throw new SmpNotFoundException("id", "applications");
        }
        this.auditFacade.LogAction(AuditTrailActions.Delete, AuditTrailObjectTypes.Application, app.getName());
        this.repo.delete(id);
        this.aupFacade.removeByApplication(app.getId());
    }

    public UccxApplication findApplicationByTrigger(String trigger) {
        return this.repo.findOneByTrigger(trigger);
    }
}

