/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.dao.ApplicationUserPermissionRepository;
import com.netsync.smp.domain.ApplicationPermissionLevel;
import com.netsync.smp.domain.ApplicationUserPermission;
import com.netsync.smp.domain.UccxApplication;
import com.netsync.smp.domain.User;
import com.netsync.smp.web.security.CurrentUser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationUserPermissionsDataFacade {
    protected ApplicationUserPermissionRepository repo;

    @Autowired
    public ApplicationUserPermissionsDataFacade(ApplicationUserPermissionRepository repo) {
        this.repo = repo;
    }

    public List<ApplicationUserPermission> findAll() {
        return this.repo.findAll();
    }

    protected List<UccxApplication> groupApps(List<ApplicationUserPermission> permissions) {
        ArrayList<UccxApplication> results = new ArrayList<UccxApplication>();
        for (ApplicationUserPermission item : permissions) {
            results.add(item.getApplication());
        }
        return results;
    }

    public List<ApplicationUserPermission> getAllAppsForUserId(String userId) {
        return this.repo.findByUser_Id(userId);
    }

    public List<UccxApplication> getReadAppsForUser(String userId) {
        return this.groupApps(this.repo.findByUser_IdAndPermission(userId, ApplicationPermissionLevel.Read));
    }

    public List<UccxApplication> getEditAppsForUser(String userId) {
        return this.groupApps(this.repo.findByUser_IdAndPermission(userId, ApplicationPermissionLevel.Edit));
    }

    public ApplicationUserPermission getPermissionsForUserAndApp(String userId, String appId) {
        return this.repo.findOneByUser_IdAndApplication_Id(userId, appId);
    }

    public boolean getCanEditApplication(String userId, String appId) {
        List editableApps = this.getEditAppsForUser(userId);
        for (UccxApplication editableApp : editableApps) {
            if (!editableApp.getId().equals(appId)) continue;
            return true;
        }
        return false;
    }

    public boolean getHasEditPermissions(User user) {
        if (null == user) {
            return false;
        }
        return !this.getEditAppsForUser(user.getUserId()).isEmpty();
    }

    public boolean getHasEditPermissions() {
        return this.getHasEditPermissions(CurrentUser.get());
    }

    public void removeByApplication(String appId) {
        this.repo.removeByApplication_Id(appId);
    }

    public void removeById(String aupId) {
        this.repo.delete(aupId);
    }

    public ApplicationUserPermission save(ApplicationUserPermission e) {
        return this.repo.save(e);
    }

    public ApplicationUserPermission create(ApplicationUserPermission e) {
        return this.repo.insert(e);
    }
}

