/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.dao.AuditTrailRepository;
import com.netsync.smp.domain.AuditEntry;
import com.netsync.smp.domain.AuditTrailActions;
import com.netsync.smp.domain.AuditTrailObjectTypes;
import com.netsync.smp.domain.User;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.web.security.CurrentUser;
import java.time.Instant;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class AuditTrailDataFacade {
    protected AuditTrailRepository repo;

    @Autowired
    public AuditTrailDataFacade(AuditTrailRepository repo) {
        this.repo = repo;
    }

    public void LogAction(AuditTrailActions action, AuditTrailObjectTypes type, String objectName, String optionalMessage) {
        StringBuilder message = new StringBuilder();
        message.append(action.toString());
        message.append(" ");
        message.append(type.toString());
        message.append(" (");
        message.append(objectName);
        message.append(").");
        if (null != optionalMessage && !optionalMessage.isEmpty()) {
            message.append(" ");
            message.append(optionalMessage);
        }
        User user = CurrentUser.get();
        this.repo.save((Object)new AuditEntry(Instant.now(), user.getUserId(), user.isAdmin(), message.toString()));
    }

    public void LogAction(AuditTrailActions action, AuditTrailObjectTypes type, String objectName) {
        this.LogAction(action, type, objectName, "");
    }

    public List<AuditEntry> getBetweenDates(Instant from, Instant to) {
        return this.repo.findByTimestampBetween(from, to);
    }

    public List<AuditEntry> getMostRecent(int count) {
        return this.repo.findAll((Pageable)new PageRequest(0, count, new Sort(Sort.Direction.DESC, new String[]{"timestamp"}))).getContent();
    }

    public List<AuditEntry> findAll() {
        return this.repo.findAll();
    }

    public AuditEntry findOneById(String id) throws SmpNotFoundException {
        AuditEntry entry = this.repo.findOneById(id);
        if (null == entry) {
            throw new SmpNotFoundException(id, "Audit Trail");
        }
        return entry;
    }
}

