/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.google.ical.compat.jodatime.LocalDateIterable;
import com.google.ical.compat.jodatime.LocalDateIteratorFactory;
import com.netsync.smp.domain.HolidayPromptGroup;
import com.netsync.smp.domain.HolidayRule;
import com.netsync.smp.domain.HolidaySchema;
import com.netsync.smp.domain.OpenCloseHours;
import com.netsync.smp.domain.QueuePromptItem;
import com.netsync.smp.domain.StandardPromptGroup;
import com.netsync.smp.domain.UccxApplication;
import com.netsync.smp.domain.uccx.CallCenterStatus;
import com.netsync.smp.domain.uccx.CallTreatment;
import com.netsync.smp.domain.uccx.CallTreatmentActions;
import com.netsync.smp.exception.SmpIllegalDataException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.joda.time.DateTimeComparator;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CallTreatmentFacade {
    private static final Logger log = LoggerFactory.getLogger(CallTreatmentFacade.class);
    static boolean debug = false;
    private static LocalDateTime localDateTime;
    private static String inputDate;

    public static CallTreatment determineCallTreatment(UccxApplication application, Locale locale, String date) {
        int i;
        CallTreatment callTreatment = CallTreatment.empty();
        callTreatment.setTrigger(application.getTrigger());
        callTreatment.setLocale(locale.toString());
        StandardPromptGroup standardPromptGroup = (StandardPromptGroup)application.getStandardPrompts().get(locale);
        log.info("determineCallTreatment");
        if (debug) {
            inputDate = date;
            localDateTime = LocalDateTime.parse(date);
            log.info("local time is " + localDateTime.toString());
        } else {
            localDateTime = LocalDateTime.now();
            log.info("local time is " + localDateTime.toString());
        }
        if (standardPromptGroup.getNotificationPrompt() == null || standardPromptGroup.getNotificationPrompt().isEmpty()) {
            callTreatment.setNotification_prompt_id("NULL");
        } else {
            callTreatment.setNotification_prompt_id(CallTreatmentFacade.removeWavExtension((String)standardPromptGroup.getNotificationPrompt()));
        }
        if (application.isEmergencyClosed()) {
            log.info("Emergency closure");
            callTreatment.setStatus(CallCenterStatus.Emergency);
            String emergencyPrompt = standardPromptGroup.getEmergencyPrompt();
            if (emergencyPrompt == null || emergencyPrompt.isEmpty()) {
                log.info("Emergency closure, but no emergency behavior defined - default to Closed behavior");
                callTreatment.setStatus_prompt_id(CallTreatmentFacade.removeWavExtension((String)standardPromptGroup.getClosedPrompt()));
                callTreatment.getBehavior().setAction(standardPromptGroup.getClosedBehavior());
                callTreatment.getBehavior().setForward_or_voicemail_number(standardPromptGroup.getClosedBehaviorNumber());
            } else {
                log.info("Playing emergency prompt and emergency behavior");
                callTreatment.setStatus_prompt_id(CallTreatmentFacade.removeWavExtension((String)emergencyPrompt));
                callTreatment.getBehavior().setAction(standardPromptGroup.getEmergencyBehavior());
                callTreatment.getBehavior().setForward_or_voicemail_number(standardPromptGroup.getEmergencyBehaviorNumber());
            }
        } else {
            OpenCloseHours openCloseHours = (OpenCloseHours)application.getOpenCloseHours().get(localDateTime.getDayOfWeek());
            LocalTime localTime = localDateTime.toLocalTime();
            if (!openCloseHours.isClosedAllDay() && localTime.isAfter(openCloseHours.getOpen()) && localTime.isBefore(openCloseHours.getClose())) {
                log.info("Within normal open hours, but we need to check for holidays first to determine if we're open or closed");
                List holidayRulesForToday = CallTreatmentFacade.holidayRulesForToday((HolidaySchema)application.getHolidaySchema());
                if (!holidayRulesForToday.isEmpty()) {
                    log.info("Today has holiday rules, now determine if we're open or closed for the holiday");
                    callTreatment.setStatus(CallCenterStatus.Holiday);
                    boolean closedForHoliday = false;
                    HolidayRule ruleToEnforce = null;
                    for (HolidayRule holidayRule : holidayRulesForToday) {
                        ruleToEnforce = holidayRule;
                        if (ruleToEnforce.getOpenCloseHours().isClosedAllDay()) {
                            log.info("Holiday Rule [" + ruleToEnforce.getName() + "] determined we are closed all day for the holiday");
                            closedForHoliday = true;
                            break;
                        }
                        LocalTime holidayOpenTime = ruleToEnforce.getOpenCloseHours().getOpen();
                        LocalTime holidayCloseTime = ruleToEnforce.getOpenCloseHours().getClose();
                        log.info("Holiday Rule openTime=[" + holidayOpenTime + "]");
                        log.info("Holiday Rule closeTime=[" + holidayCloseTime + "]");
                        if (holidayOpenTime.isBefore(holidayCloseTime)) {
                            if (localTime.isAfter(holidayOpenTime) && localTime.isBefore(holidayCloseTime)) {
                                log.info("Holiday Rule [" + ruleToEnforce.getName() + "] determined we are open under modified hours; continue looping through holidays");
                                continue;
                            }
                            log.info("Holiday Rule [" + ruleToEnforce.getName() + "] determined we are closed for the holiday under modified hours");
                            closedForHoliday = true;
                            break;
                        }
                        if (localTime.isAfter(holidayCloseTime) && localTime.isBefore(holidayOpenTime)) {
                            log.info("Holiday Rule [" + ruleToEnforce.getName() + "] determined we are closed for the holiday under blackout hours");
                            closedForHoliday = true;
                            break;
                        }
                        log.info("Holiday Rule [" + ruleToEnforce.getName() + "] determined we are open under blackout hours; continue looping through holidays");
                    }
                    log.info("Retrieving prompts for holiday rule [" + ruleToEnforce.getName() + "] and locale [" + locale.toLanguageTag() + "]");
                    HolidayPromptGroup holidayPrompts = (HolidayPromptGroup)ruleToEnforce.getHolidayPrompts().get(locale);
                    if (closedForHoliday) {
                        log.info("Closed for the holiday, playing closed for holiday prompt");
                        callTreatment.setStatus_prompt_id(CallTreatmentFacade.removeWavExtension((String)holidayPrompts.getClosedPrompt()));
                        callTreatment.getBehavior().setAction(holidayPrompts.getClosedBehavior());
                        callTreatment.getBehavior().setForward_or_voicemail_number(holidayPrompts.getClosedBehaviorNumber());
                    } else {
                        log.info("Holiday, but we're still open");
                        if (holidayPrompts.getOpenPrompt() == null || holidayPrompts.getOpenPrompt().isEmpty()) {
                            log.info("Open for the holiday, but no holiday prompt found");
                            if (standardPromptGroup.getOpenPrompt() == null || standardPromptGroup.getOpenPrompt().isEmpty()) {
                                log.info("Would play standard open prompt, but none found - setting to NULL");
                                callTreatment.setStatus_prompt_id("NULL");
                            } else {
                                log.info("Use standard open prompt instead of holiday prompt");
                                callTreatment.setStatus_prompt_id(CallTreatmentFacade.removeWavExtension((String)standardPromptGroup.getOpenPrompt()));
                            }
                            callTreatment.getBehavior().setAction(CallTreatmentActions.Unknown);
                            callTreatment.getBehavior().setForward_or_voicemail_number("NULL");
                        } else {
                            log.info("Open for holiday, playing open for holiday prompt");
                            callTreatment.setStatus_prompt_id(CallTreatmentFacade.removeWavExtension((String)holidayPrompts.getOpenPrompt()));
                            callTreatment.getBehavior().setAction(CallTreatmentActions.Unknown);
                            callTreatment.getBehavior().setForward_or_voicemail_number("NULL");
                        }
                    }
                } else {
                    log.info("Normal open hours");
                    callTreatment.setStatus(CallCenterStatus.Open);
                    if (standardPromptGroup.getOpenPrompt() == null || standardPromptGroup.getOpenPrompt().isEmpty()) {
                        log.info("Would play standard open prompt, but none found - setting to NULL");
                        callTreatment.setStatus_prompt_id("NULL");
                    } else {
                        log.info("Use standard open prompt");
                        callTreatment.setStatus_prompt_id(CallTreatmentFacade.removeWavExtension((String)standardPromptGroup.getOpenPrompt()));
                    }
                    callTreatment.getBehavior().setAction(CallTreatmentActions.Unknown);
                    callTreatment.getBehavior().setForward_or_voicemail_number("NULL");
                }
            } else {
                log.info("Normal closed hours");
                callTreatment.setStatus(CallCenterStatus.Closed);
                callTreatment.setStatus_prompt_id(CallTreatmentFacade.removeWavExtension((String)standardPromptGroup.getClosedPrompt()));
                callTreatment.getBehavior().setAction(standardPromptGroup.getClosedBehavior());
                callTreatment.getBehavior().setForward_or_voicemail_number(standardPromptGroup.getClosedBehaviorNumber());
            }
        }
        QueuePromptItem[] queuePrompts = standardPromptGroup.getQueuePrompts();
        QueuePromptItem[] queuePromptBuffer = new QueuePromptItem[10];
        for (i = 0; i < queuePromptBuffer.length; ++i) {
            QueuePromptItem qpi = new QueuePromptItem();
            qpi.setIndex(i + 1);
            qpi.setPlayHoldMusic(Boolean.valueOf(false));
            qpi.setPrompt("NULL");
            qpi.setQueueDelayTime(new Integer(0));
            queuePromptBuffer[i] = qpi;
        }
        if (queuePrompts != null && queuePrompts.length > 0) {
            for (i = 0; i < queuePrompts.length; ++i) {
                queuePromptBuffer[i] = queuePrompts[i];
                log.info("Buffer index [" + i + "] has queue prompt index of [" + queuePrompts[i].getIndex() + "]");
            }
        }
        callTreatment.getQueue().getQueue_prompt_0().setPrompt(CallTreatmentFacade.removeWavExtension((String)queuePromptBuffer[0].getPrompt()));
        callTreatment.getQueue().getQueue_prompt_0().setDelay(queuePromptBuffer[0].getQueueDelayTime());
        callTreatment.getQueue().getQueue_prompt_0().setMusic(queuePromptBuffer[0].getPlayHoldMusic());
        callTreatment.getQueue().getQueue_prompt_1().setPrompt(CallTreatmentFacade.removeWavExtension((String)queuePromptBuffer[1].getPrompt()));
        callTreatment.getQueue().getQueue_prompt_1().setDelay(queuePromptBuffer[1].getQueueDelayTime());
        callTreatment.getQueue().getQueue_prompt_1().setMusic(queuePromptBuffer[1].getPlayHoldMusic());
        callTreatment.getQueue().getQueue_prompt_2().setPrompt(CallTreatmentFacade.removeWavExtension((String)queuePromptBuffer[2].getPrompt()));
        callTreatment.getQueue().getQueue_prompt_2().setDelay(queuePromptBuffer[2].getQueueDelayTime());
        callTreatment.getQueue().getQueue_prompt_2().setMusic(queuePromptBuffer[2].getPlayHoldMusic());
        callTreatment.getQueue().getQueue_prompt_3().setPrompt(CallTreatmentFacade.removeWavExtension((String)queuePromptBuffer[3].getPrompt()));
        callTreatment.getQueue().getQueue_prompt_3().setDelay(queuePromptBuffer[3].getQueueDelayTime());
        callTreatment.getQueue().getQueue_prompt_3().setMusic(queuePromptBuffer[3].getPlayHoldMusic());
        callTreatment.getQueue().getQueue_prompt_4().setPrompt(CallTreatmentFacade.removeWavExtension((String)queuePromptBuffer[4].getPrompt()));
        callTreatment.getQueue().getQueue_prompt_4().setDelay(queuePromptBuffer[4].getQueueDelayTime());
        callTreatment.getQueue().getQueue_prompt_4().setMusic(queuePromptBuffer[4].getPlayHoldMusic());
        callTreatment.getQueue().getQueue_prompt_5().setPrompt(CallTreatmentFacade.removeWavExtension((String)queuePromptBuffer[5].getPrompt()));
        callTreatment.getQueue().getQueue_prompt_5().setDelay(queuePromptBuffer[5].getQueueDelayTime());
        callTreatment.getQueue().getQueue_prompt_5().setMusic(queuePromptBuffer[5].getPlayHoldMusic());
        callTreatment.getQueue().getQueue_prompt_6().setPrompt(CallTreatmentFacade.removeWavExtension((String)queuePromptBuffer[6].getPrompt()));
        callTreatment.getQueue().getQueue_prompt_6().setDelay(queuePromptBuffer[6].getQueueDelayTime());
        callTreatment.getQueue().getQueue_prompt_6().setMusic(queuePromptBuffer[6].getPlayHoldMusic());
        callTreatment.getQueue().getQueue_prompt_7().setPrompt(CallTreatmentFacade.removeWavExtension((String)queuePromptBuffer[7].getPrompt()));
        callTreatment.getQueue().getQueue_prompt_7().setDelay(queuePromptBuffer[7].getQueueDelayTime());
        callTreatment.getQueue().getQueue_prompt_7().setMusic(queuePromptBuffer[7].getPlayHoldMusic());
        callTreatment.getQueue().getQueue_prompt_8().setPrompt(CallTreatmentFacade.removeWavExtension((String)queuePromptBuffer[8].getPrompt()));
        callTreatment.getQueue().getQueue_prompt_8().setDelay(queuePromptBuffer[8].getQueueDelayTime());
        callTreatment.getQueue().getQueue_prompt_8().setMusic(queuePromptBuffer[8].getPlayHoldMusic());
        callTreatment.getQueue().getQueue_prompt_9().setPrompt(CallTreatmentFacade.removeWavExtension((String)queuePromptBuffer[9].getPrompt()));
        callTreatment.getQueue().getQueue_prompt_9().setDelay(queuePromptBuffer[9].getQueueDelayTime());
        callTreatment.getQueue().getQueue_prompt_9().setMusic(queuePromptBuffer[9].getPlayHoldMusic());
        return callTreatment;
    }

    private static String removeWavExtension(String promptName) {
        if (null == promptName || StringUtils.isEmpty((Object)promptName)) {
            return "NULL";
        }
        String[] words = promptName.split("\\.wav");
        return words[0];
    }

    private static List<HolidayRule> holidayRulesForToday(HolidaySchema holidaySchema) {
        ArrayList<HolidayRule> holidayRulesForToday = new ArrayList<HolidayRule>();
        if (holidaySchema == null || holidaySchema.getHolidayRules() == null || holidaySchema.getHolidayRules().isEmpty()) {
            log.info("No holiday rules found in given holiday schema");
            return holidayRulesForToday;
        }
        for (HolidayRule holidayRule : holidaySchema.getHolidayRules()) {
            try {
                if (!CallTreatmentFacade.isTodayAHoliday((HolidayRule)holidayRule)) continue;
                log.info("Holiday rule [" + holidayRule.getName() + "] has an instance that occurs today");
                holidayRulesForToday.add(holidayRule);
            }
            catch (SmpIllegalDataException e) {
                log.warn(e.getMessage());
            }
        }
        return holidayRulesForToday;
    }

    private static boolean isTodayAHoliday(HolidayRule holidayRule) throws SmpIllegalDataException {
        try {
            LocalDate today;
            log.info("Entering isTodayAHoliday()");
            if (debug) {
                String tempDate = inputDate.substring(0, 10);
                today = LocalDate.parse((String)tempDate);
            } else {
                today = LocalDate.now();
            }
            log.info("Today is [" + today.toString() + "]");
            log.info("Start date of the recurrence is [" + holidayRule.getDtstart().toString() + "]");
            log.info("RRule is [" + holidayRule.getRule() + "]");
            LocalDateIterable localDateIterable = LocalDateIteratorFactory.createLocalDateIterable((String)holidayRule.getRule(), (LocalDate)new LocalDate((Object)holidayRule.getDtstart().toString()), (DateTimeZone)DateTimeZone.getDefault(), (boolean)true);
            for (LocalDate date : localDateIterable) {
                log.info("Holiday date is [" + date.toString() + "]");
                int compareResult = DateTimeComparator.getDateOnlyInstance().compare((Object)today.toDateTimeAtStartOfDay(), (Object)date.toDateTimeAtStartOfDay());
                if (compareResult == 0) {
                    log.info("Today is a holiday: " + date.toDateTimeAtStartOfDay());
                    return true;
                }
                if (compareResult < 0) {
                    log.info("Holiday instance is in the future; today is not a holiday: " + date.toDateTimeAtStartOfDay());
                    return false;
                }
                log.info("Holiday instance is in the past; keep going");
            }
        }
        catch (ParseException e) {
            log.error("Exception in parsing RRule string [" + holidayRule.getRule() + "]", (Throwable)e);
            throw new SmpIllegalDataException(e.getMessage());
        }
        return false;
    }
}

