/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.domain.finesse.FinesseUser;
import com.netsync.smp.domain.finesse.ListOfFinesseUsers;
import com.netsync.smp.domain.frontend.LoginParams;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.web.config.FinesseRestTemplate;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class FinesseDataFacade {
    private static final Logger log = LoggerFactory.getLogger(FinesseDataFacade.class);
    protected FinesseRestTemplate finesseRest;
    protected static Unmarshaller unmarshaller;

    @Autowired
    public FinesseDataFacade(FinesseRestTemplate finesseRest) {
        this.finesseRest = finesseRest;
    }

    protected static List<FinesseUser> unmarshalToFinesseUserArrayList(String xmlBody) {
        StringReader reader = new StringReader(xmlBody);
        try {
            return ((ListOfFinesseUsers)unmarshaller.unmarshal((Reader)reader)).getUserList();
        }
        catch (Exception e) {
            log.warn("unmarshalToFinesseUserArrayList: " + e.getMessage());
            return new ArrayList<FinesseUser>();
        }
    }

    private static HttpHeaders basicHeaderAuth(String username, String password) {
        String plainCreds = username + ":" + password;
        String base64Creds = new String(Base64.encodeBase64((byte[])plainCreds.getBytes()));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Creds);
        return headers;
    }

    public boolean validateUser(LoginParams loginParams) {
        HttpHeaders headers = FinesseDataFacade.basicHeaderAuth((String)loginParams.getUserId(), (String)loginParams.getPassword());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.finesseRest.callGet("finesse/api/User/" + loginParams.getUserId(), request, String.class, new Object[0]);
            return HttpStatus.OK.equals((Object)response.getStatusCode());
        }
        catch (Exception e) {
            log.warn("validateUser: " + e.getMessage());
            return false;
        }
    }

    public List<FinesseUser> findUserNames() throws SmpNotFoundException {
        HttpHeaders headers = FinesseDataFacade.basicHeaderAuth((String)this.finesseRest.getFinesseAdminUsername(), (String)this.finesseRest.getFinesseAdminPassword());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.finesseRest.callGet("finesse/api/Users/", request, String.class, new Object[0]);
            if (!HttpStatus.OK.equals((Object)response.getStatusCode())) {
                throw new SmpNotFoundException("UserNames", "Finesse");
            }
            return FinesseDataFacade.unmarshalToFinesseUserArrayList((String)((String)response.getBody()));
        }
        catch (Exception e) {
            log.warn("getUserNames: " + e.getMessage());
            throw new SmpNotFoundException("UserNames", "Finesse");
        }
    }

    public void clearUserNames() {
    }

    static {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ListOfFinesseUsers.class});
            unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            unmarshaller = null;
        }
    }
}

