/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.dao.HolidayRuleRepository;
import com.netsync.smp.domain.AuditTrailActions;
import com.netsync.smp.domain.AuditTrailObjectTypes;
import com.netsync.smp.domain.HolidayRule;
import com.netsync.smp.domain.HolidaySchema;
import com.netsync.smp.domain.OpenCloseHours;
import com.netsync.smp.domain.User;
import com.netsync.smp.domain.frontend.SmpDatabaseId;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.ApplicationUserPermissionsDataFacade;
import com.netsync.smp.logic.AuditTrailDataFacade;
import com.netsync.smp.logic.HolidaySchemaDataFacade;
import com.netsync.smp.logic.UserDataFacade;
import com.netsync.smp.web.security.CurrentUser;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.UsesJava8;
import org.springframework.stereotype.Component;

@Component
@UsesJava8
public class HolidayRuleDataFacade {
    private static final Logger log = LoggerFactory.getLogger(HolidayRuleDataFacade.class);
    protected HolidayRuleRepository repo;
    protected ApplicationUserPermissionsDataFacade aupFacade;
    protected UserDataFacade userFacade;
    protected HolidaySchemaDataFacade schemaFacade;
    protected AuditTrailDataFacade auditFacade;

    @Autowired
    public HolidayRuleDataFacade(HolidayRuleRepository repo, ApplicationUserPermissionsDataFacade aupFacade, UserDataFacade userFacade, HolidaySchemaDataFacade schemaFacade, AuditTrailDataFacade auditFacade) {
        this.repo = repo;
        this.aupFacade = aupFacade;
        this.userFacade = userFacade;
        this.schemaFacade = schemaFacade;
        this.auditFacade = auditFacade;
    }

    public SmpDatabaseId addHolidayRuleToHolidaySchema(String holidaySchemaId, String holidayRuleId) throws SmpNotFoundException, SmpIllegalDataException, SmpNotAuthorizedException {
        HolidayRule holidayRule = this.repo.findOneById(holidayRuleId);
        if (holidayRule == null) {
            throw new SmpNotFoundException(holidayRuleId, "holidayRulesId");
        }
        HolidaySchema holidaySchema = this.schemaFacade.findOneById(holidaySchemaId);
        if (holidaySchema == null) {
            throw new SmpNotFoundException(holidaySchemaId, "holidaySchemaId");
        }
        holidaySchema.getHolidayRules().add(holidayRule);
        this.schemaFacade.update(holidaySchemaId, holidaySchema, Boolean.valueOf(true));
        return new SmpDatabaseId(holidaySchemaId, "holidaySchemaId");
    }

    public SmpDatabaseId removeHolidayRuleFromHolidaySchema(String holidaySchemaId, String holidayRuleId) throws SmpNotFoundException, SmpIllegalDataException, SmpNotAuthorizedException {
        HolidayRule holidayRule = this.repo.findOneById(holidayRuleId);
        if (holidayRule == null) {
            throw new SmpNotFoundException(holidayRuleId, "holidayRulesId");
        }
        HolidaySchema holidaySchema = this.schemaFacade.findOneById(holidaySchemaId);
        if (holidaySchema == null) {
            throw new SmpNotFoundException(holidaySchemaId, "holidaySchemaId");
        }
        if (holidaySchema.getHolidayRules().remove(holidayRule)) {
            log.info("Successfully removed holiday rule [" + holidayRuleId + "] from holiday schema [" + holidaySchemaId + "]");
        } else {
            log.warn("Attempted to remove holiday rule [" + holidayRuleId + "] from holiday schema [" + holidaySchemaId + "], but not found in schema");
        }
        this.schemaFacade.update(holidaySchemaId, holidaySchema, Boolean.valueOf(true));
        return new SmpDatabaseId(holidaySchemaId, "holidaySchemaId");
    }

    public HolidayRule findOneById(String id) throws SmpNotFoundException {
        User user = CurrentUser.get();
        HolidayRule holidayRule = this.repo.findOneById(id);
        if (holidayRule == null || !user.isAdmin()) {
            throw new SmpNotFoundException("id", "holidayRules");
        }
        return holidayRule;
    }

    public HolidayRule findOneByName(String name) {
        return this.repo.findOneByName(name);
    }

    public Set<HolidayRule> getAllHolidayRules() {
        return new HashSet<HolidayRule>(this.repo.findAll());
    }

    protected void checkCreateOrUpdate(HolidayRule holidayRule) throws SmpIllegalDataException, SmpNotAuthorizedException {
        if (null == holidayRule) {
            throw new SmpIllegalDataException("Must be a valid HolidayRule object");
        }
        if (!CurrentUser.isAdmin() && !this.aupFacade.getHasEditPermissions()) {
            throw new SmpNotAuthorizedException("create or update holiday rules");
        }
    }

    public SmpDatabaseId create(HolidayRule holidayRule) throws SmpIllegalDataException, SmpNotAuthorizedException {
        this.checkCreateOrUpdate(holidayRule);
        if (null != holidayRule.getId() && !holidayRule.getId().isEmpty()) {
            throw new SmpIllegalDataException("ID must be empty to create");
        }
        this.auditFacade.LogAction(AuditTrailActions.Create, AuditTrailObjectTypes.HolidayRule, holidayRule.getName());
        return new SmpDatabaseId(this.repo.insert(holidayRule).getId(), "holidayRule");
    }

    public SmpDatabaseId update(String id, HolidayRule holidayRule, Boolean check) throws SmpIllegalDataException, SmpNotAuthorizedException {
        if (check.booleanValue()) {
            this.checkCreateOrUpdate(holidayRule);
        }
        if (id == null || id.isEmpty()) {
            throw new SmpIllegalDataException("ID must be valid to create");
        }
        if (!id.equals(holidayRule.getId())) {
            throw new SmpIllegalDataException("URL ID must match payload ID");
        }
        if (check.booleanValue()) {
            this.auditFacade.LogAction(AuditTrailActions.Update, AuditTrailObjectTypes.HolidayRule, holidayRule.getName());
        }
        return new SmpDatabaseId(this.repo.save(holidayRule).getId(), "holidayRule");
    }

    public void delete(String id) throws SmpNotAuthorizedException, SmpIllegalDataException {
        if (!CurrentUser.isAdmin() && !this.aupFacade.getHasEditPermissions()) {
            throw new SmpNotAuthorizedException("delete holidayRules");
        }
        HolidayRule holidayRule = this.repo.findOneById(id);
        if (null == holidayRule) {
            throw new SmpIllegalDataException("Cannot delete a non-existent holidayRule");
        }
        if (this.schemaFacade.isHolidayRuleUsed(id)) {
            throw new SmpIllegalDataException("Cannot delete a holiday rule in use by a holiday schema");
        }
        this.auditFacade.LogAction(AuditTrailActions.Delete, AuditTrailObjectTypes.HolidayRule, holidayRule.getName());
        this.repo.delete(id);
    }

    @PostConstruct
    protected SmpDatabaseId makeDefaultHolidaySchema() throws SmpIllegalDataException, SmpNotAuthorizedException {
        HolidaySchema existing = this.schemaFacade.findOneByName("Default US Holidays");
        if (existing.getHolidayRules().isEmpty()) {
            HashSet<HolidayRule> holidayRules = new HashSet<HolidayRule>();
            String[] holidaysNames = new String[]{"New Year's Day", "Memorial Day", "Independence Day", "Labor Day", "Thanksgiving", "Christmas Eve", "Christmas", "New Year's Eve"};
            List<String> usHolidaysList = Arrays.asList(holidaysNames);
            for (String str : usHolidaysList) {
                HolidayRule holidayRule = new HolidayRule();
                holidayRule.setName(str);
                holidayRules.add(this.setHolidayRuleValues(holidayRule));
            }
            existing.setHolidayRules(holidayRules);
            return this.schemaFacade.update(existing.getId(), existing, Boolean.valueOf(false));
        }
        return new SmpDatabaseId(existing.getId(), "Holiday Schema");
    }

    private HolidayRule setHolidayRuleValues(HolidayRule holidayRule) {
        int currentYear = 2015;
        switch (holidayRule.getName()) {
            case "New Year's Day": {
                holidayRule.setDtstart(LocalDate.parse(currentYear + "-01-01"));
                holidayRule.setRule("RRULE:FREQ=YEARLY");
                holidayRule.setRecurring(true);
                break;
            }
            case "Memorial Day": {
                holidayRule.setDtstart(LocalDate.parse(currentYear + "-05-25"));
                holidayRule.setRule("RRULE:FREQ=YEARLY;WKST=MO;BYDAY=MO;BYMONTH=5;BYSETPOS=-1");
                holidayRule.setRecurring(true);
                break;
            }
            case "Independence Day": {
                holidayRule.setDtstart(LocalDate.parse(currentYear + "-07-04"));
                holidayRule.setRule("RRULE:FREQ=YEARLY");
                holidayRule.setRecurring(true);
                break;
            }
            case "Labor Day": {
                holidayRule.setDtstart(LocalDate.parse(currentYear + "-09-07"));
                holidayRule.setRule("RRULE:FREQ=YEARLY;WKST=MO;BYDAY=MO;BYMONTH=9;BYSETPOS=1");
                holidayRule.setRecurring(true);
                break;
            }
            case "Thanksgiving": {
                holidayRule.setDtstart(LocalDate.parse(currentYear + "-11-26"));
                holidayRule.setRule("RRULE:FREQ=YEARLY;WKST=MO;BYDAY=TH;BYMONTH=11;BYSETPOS=-1");
                holidayRule.setRecurring(true);
                break;
            }
            case "Christmas Eve": {
                holidayRule.setDtstart(LocalDate.parse(currentYear + "-12-24"));
                holidayRule.setRule("RRULE:FREQ=YEARLY");
                holidayRule.setRecurring(true);
                break;
            }
            case "Christmas": {
                holidayRule.setDtstart(LocalDate.parse(currentYear + "-12-25"));
                holidayRule.setRule("RRULE:FREQ=YEARLY");
                holidayRule.setRecurring(true);
                break;
            }
            case "New Year's Eve": {
                holidayRule.setDtstart(LocalDate.parse(currentYear + "-12-31"));
                holidayRule.setRule("RRULE:FREQ=YEARLY");
                holidayRule.setRecurring(true);
            }
        }
        holidayRule.setOpenCloseHours(new OpenCloseHours(LocalTime.parse("00:00"), LocalTime.parse("23:59"), true));
        holidayRule.setHolidayPrompts(new HashMap());
        return this.repo.save(holidayRule);
    }
}

