/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.dao.HolidaySchemaRepository;
import com.netsync.smp.domain.AuditTrailActions;
import com.netsync.smp.domain.AuditTrailObjectTypes;
import com.netsync.smp.domain.HolidayRule;
import com.netsync.smp.domain.HolidaySchema;
import com.netsync.smp.domain.frontend.SmpDatabaseId;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.logic.ApplicationDataFacade;
import com.netsync.smp.logic.ApplicationUserPermissionsDataFacade;
import com.netsync.smp.logic.AuditTrailDataFacade;
import com.netsync.smp.logic.UserDataFacade;
import com.netsync.smp.web.security.CurrentUser;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.UsesJava8;
import org.springframework.stereotype.Component;

@Component
@UsesJava8
public class HolidaySchemaDataFacade {
    protected HolidaySchemaRepository repo;
    protected ApplicationDataFacade appFacade;
    protected ApplicationUserPermissionsDataFacade aupFacade;
    protected UserDataFacade userFacade;
    protected AuditTrailDataFacade auditFacade;

    @Autowired
    public HolidaySchemaDataFacade(HolidaySchemaRepository repo, ApplicationDataFacade appFacade, ApplicationUserPermissionsDataFacade aupFacade, UserDataFacade userFacade, AuditTrailDataFacade auditFacade) {
        this.repo = repo;
        this.appFacade = appFacade;
        this.aupFacade = aupFacade;
        this.userFacade = userFacade;
        this.auditFacade = auditFacade;
    }

    protected void checkCreateOrUpdate(HolidaySchema schema) throws SmpIllegalDataException, SmpNotAuthorizedException {
        if (null == schema) {
            throw new SmpIllegalDataException("Must be a valid HolidaySchema object");
        }
        if (!CurrentUser.isAdmin() && !this.aupFacade.getHasEditPermissions()) {
            throw new SmpNotAuthorizedException("create or update holiday schemas");
        }
        for (HolidayRule h : schema.getHolidayRules()) {
            if (null != h.getId() && !h.getId().isEmpty()) continue;
            throw new SmpIllegalDataException("Cannot create or update a schema with invalid holiday rules.");
        }
    }

    public SmpDatabaseId create(HolidaySchema schema) throws SmpIllegalDataException, SmpNotAuthorizedException {
        this.checkCreateOrUpdate(schema);
        if (null != schema.getId() && !schema.getId().isEmpty()) {
            throw new SmpIllegalDataException("ID must be empty to create");
        }
        this.auditFacade.LogAction(AuditTrailActions.Create, AuditTrailObjectTypes.HolidaySchema, schema.getName());
        return new SmpDatabaseId(this.repo.insert(schema).getId(), "HolidaySchema");
    }

    public SmpDatabaseId update(String id, HolidaySchema schema, Boolean check) throws SmpIllegalDataException, SmpNotAuthorizedException {
        if (check.booleanValue()) {
            this.checkCreateOrUpdate(schema);
        }
        if (id == null || id.isEmpty()) {
            throw new SmpIllegalDataException("ID must be valid to create");
        }
        if (!id.equals(schema.getId())) {
            throw new SmpIllegalDataException("URL ID must match payload ID");
        }
        if (check.booleanValue()) {
            this.auditFacade.LogAction(AuditTrailActions.Update, AuditTrailObjectTypes.HolidaySchema, schema.getName());
        }
        return new SmpDatabaseId(this.repo.save(schema).getId(), "HolidaySchema");
    }

    public HolidaySchema findOneById(String id) {
        return this.repo.findOneById(id);
    }

    public HolidaySchema findOneByName(String name) {
        return this.repo.findOneByName(name);
    }

    public Set<HolidaySchema> findAll() {
        List schemas = this.repo.findAll();
        return null == schemas ? new HashSet<HolidaySchema>() : new HashSet(schemas);
    }

    public void delete(String id) throws SmpNotAuthorizedException, SmpIllegalDataException {
        if (!CurrentUser.isAdmin() && !this.aupFacade.getHasEditPermissions()) {
            throw new SmpNotAuthorizedException("delete holiday schemas");
        }
        HolidaySchema schema = this.findOneById(id);
        if (null == schema) {
            throw new SmpIllegalDataException("Cannot delete a non-existent holiday schema");
        }
        if (this.appFacade.isHolidaySchemaUsed(id)) {
            throw new SmpIllegalDataException("Cannot delete holiday schema in use by an application");
        }
        this.auditFacade.LogAction(AuditTrailActions.Update, AuditTrailObjectTypes.HolidaySchema, schema.getName());
        this.repo.delete((Object)schema);
    }

    public boolean isHolidayRuleUsed(String holidayRuleId) {
        List all = this.repo.findAll();
        for (HolidaySchema schema : all) {
            for (HolidayRule holidayRule : schema.getHolidayRules()) {
                if (!holidayRule.getId().equals(holidayRuleId)) continue;
                return true;
            }
        }
        return false;
    }

    @PostConstruct
    protected void makeDefaultHolidaySchema() {
        HolidaySchema created;
        HolidaySchema existing = this.findOneByName("default-schema");
        Set emptyHolidayRule = Collections.emptySet();
        if (null == existing) {
            created = new HolidaySchema("default-schema", emptyHolidayRule);
            this.repo.insert(created);
        } else {
            existing.setName("default-schema");
            existing.setHolidayRules(emptyHolidayRule);
            this.repo.save(existing);
        }
        existing = this.findOneByName("Default US Holidays");
        emptyHolidayRule = Collections.emptySet();
        if (null == existing) {
            created = new HolidaySchema("Default US Holidays", emptyHolidayRule);
            this.repo.insert(created);
        }
    }
}

