/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.dao.InformixRepository;
import com.netsync.smp.domain.frontend.UccxLocaleItem;
import com.netsync.smp.domain.informix.InformixPrompt;
import com.netsync.smp.domain.informix.InformixTriggerApp;
import com.netsync.smp.exception.SmpNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InformixDataFacade {
    private static final Logger log = LoggerFactory.getLogger(InformixDataFacade.class);
    protected InformixRepository informixRepo;

    @Autowired
    public InformixDataFacade(InformixRepository informixRepo) {
        this.informixRepo = informixRepo;
    }

    public List<InformixTriggerApp> findAppsTriggers() throws SmpNotFoundException {
        try {
            return this.informixRepo.findAppsTriggers();
        }
        catch (Exception e) {
            log.warn("findAppsTriggers: " + e.getMessage());
            throw new SmpNotFoundException("Apps and Triggers", "Informix");
        }
    }

    public void clearAppsTriggers() {
        this.informixRepo.clearAppsTriggers();
    }

    public Map<String, List<InformixPrompt>> findPrompts() throws SmpNotFoundException {
        try {
            return this.informixRepo.findPrompts().stream().collect(Collectors.groupingBy(InformixPrompt::getLocale));
        }
        catch (Exception e) {
            log.warn("findPrompts: " + e.getMessage());
            throw new SmpNotFoundException("Prompts", "Informix");
        }
    }

    public Map<String, UccxLocaleItem> findLocales() throws SmpNotFoundException {
        Set locales = this.findPrompts().keySet();
        HashMap<String, UccxLocaleItem> localeObjects = new HashMap<String, UccxLocaleItem>();
        for (String locale : locales) {
            localeObjects.put(locale, new UccxLocaleItem(locale));
        }
        return localeObjects;
    }

    public void clearPrompts() {
        this.informixRepo.clearPrompts();
    }
}

