/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.dao.SystemSettingsRepository;
import com.netsync.smp.domain.HashedPassword;
import com.netsync.smp.domain.SmpInetSocketAddress;
import com.netsync.smp.domain.SmpVersion;
import com.netsync.smp.domain.SystemSettings;
import com.netsync.smp.domain.frontend.Alert;
import com.netsync.smp.domain.frontend.LicenseKey;
import com.netsync.smp.domain.frontend.LicenseValidity;
import com.netsync.smp.domain.frontend.SmpDateTime;
import com.netsync.smp.domain.frontend.SmpTimeZone;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.ApplicationDataFacade;
import com.netsync.smp.logic.HolidayRuleDataFacade;
import com.netsync.smp.logic.HolidaySchemaDataFacade;
import com.netsync.smp.logic.InformixDataFacade;
import com.netsync.smp.web.security.CurrentUser;
import com.netsync.smp.web.security.PasswordEncoder;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
@PropertySource(value={"classpath:/application.properties"})
public class SettingsDataFacade {
    private static final Logger log = LoggerFactory.getLogger(SettingsDataFacade.class);
    private static String licenseQueryParams = "key={key}&currentVersion={currentVersion}&uccxVersion={uccxVersion}";
    private static String checkPath = "/api/softwareUpdate";
    protected SystemSettingsRepository repo;
    protected HolidayRuleDataFacade holidayFacade;
    protected HolidaySchemaDataFacade schemaFacade;
    protected ApplicationDataFacade appFacade;
    protected InformixDataFacade informixFacade;
    protected SystemSettings settings;
    protected SmpVersion version;
    @Value(value="${users.default_password}")
    protected String default_password;
    @Value(value="${version}")
    protected String versionProp;
    @Value(value="${license.uccxVersion}")
    protected String uccxVersion;
    @Value(value="${license.ip}")
    protected String licenseHost;
    @Value(value="${LicenseKey}")
    protected String key;
    @Value(value="${ldap.disabled:false}")
    protected boolean ldapDisabled;
    protected static final SmpTimeZone systemTimezone = new SmpTimeZone(SimpleTimeZone.getDefault());

    @Autowired
    public SettingsDataFacade(SystemSettingsRepository repo, HolidayRuleDataFacade holidayFacade, HolidaySchemaDataFacade schemaFacade, ApplicationDataFacade appFacade, InformixDataFacade informixFacade) {
        this.repo = repo;
        this.holidayFacade = holidayFacade;
        this.schemaFacade = schemaFacade;
        this.appFacade = appFacade;
        this.informixFacade = informixFacade;
    }

    @PostConstruct
    protected void populateSettings() {
        List all = this.repo.findAll();
        if (all.size() > 1) {
            for (int i = 1; i < all.size(); ++i) {
                this.repo.delete((Serializable)((Object)((SystemSettings)all.get(i)).getId()));
            }
            all = this.repo.findAll();
        }
        if (all.size() > 0) {
            this.settings = (SystemSettings)all.get(0);
        } else {
            this.settings = new SystemSettings("", new SmpInetSocketAddress("", Integer.valueOf(0)), new SmpInetSocketAddress("", Integer.valueOf(0)));
            this.settings = (SystemSettings)this.repo.insert((Object)this.settings);
        }
        this.version = new SmpVersion(this.versionProp);
    }

    public boolean isLdapDisabled() {
        return this.ldapDisabled;
    }

    public LicenseKey getLicenseKey() {
        return new LicenseKey(this.settings.getLicenseKey());
    }

    public void setLicenseKey(LicenseKey licenseKey) throws SmpNotAuthorizedException {
        if (!CurrentUser.isAdmin()) {
            throw new SmpNotAuthorizedException("update license key");
        }
        this.settings.setLicenseKey(licenseKey.getKey());
        this.settings = (SystemSettings)this.repo.save((Object)this.settings);
    }

    public LicenseValidity getLicenseValidity() {
        Map latestVersion = this.determineLatestVersion();
        if (Boolean.FALSE.equals(latestVersion.get("licenseValid")) || Boolean.FALSE.equals(latestVersion.get("licenceValid"))) {
            return new LicenseValidity(false);
        }
        return new LicenseValidity(true);
    }

    public List<Alert> getAlerts() {
        Map latestVersion;
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        if (this.holidayFacade.getAllHolidayRules().isEmpty()) {
            alerts.add(new Alert("No holiday rules have been configured"));
        }
        if (this.schemaFacade.findAll().isEmpty()) {
            alerts.add(new Alert("No holiday schemas have been configured"));
        }
        if (this.appFacade.findAll().isEmpty()) {
            alerts.add(new Alert("No applications have been configured"));
        }
        if (Boolean.FALSE.equals((latestVersion = this.determineLatestVersion()).get("licenseValid")) || Boolean.FALSE.equals(latestVersion.get("licenceValid"))) {
            alerts.add(new Alert("Your License has expired."));
        } else if (!Boolean.FALSE.equals(latestVersion.get("updateAvailable"))) {
            alerts.add(new Alert("A new update is available. Go to Settings > Update Application to begin."));
        }
        if (PasswordEncoder.matches((String)this.default_password, (HashedPassword)CurrentUser.get().getHashedPassword())) {
            alerts.add(new Alert("Please change your password from the default password"));
        }
        try {
            if (this.informixFacade.findAppsTriggers().isEmpty()) {
                alerts.add(new Alert("No applications or triggers are available in the UCCX database"));
            }
        }
        catch (SmpNotFoundException e) {
            alerts.add(new Alert("No connection is available to the UCCX database"));
        }
        return alerts;
    }

    public Map<String, Object> determineLatestVersion() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("key", this.key);
        vars.put("currentVersion", this.versionProp);
        vars.put("uccxVersion", this.uccxVersion);
        String licenseCheckUrl = "http://" + this.licenseHost + checkPath + "?" + licenseQueryParams;
        try {
            log.debug("Checking license against " + licenseCheckUrl);
            return (Map)new RestTemplate().getForObject(licenseCheckUrl, Map.class, vars);
        }
        catch (RestClientException e) {
            log.warn("Could not retrieve latest version details with at URL: " + licenseCheckUrl + " with params: " + vars);
            return null;
        }
    }

    public SmpDateTime getSystemDatetime() {
        return new SmpDateTime(Instant.now());
    }

    public SmpVersion getVersion() {
        return this.version;
    }

    public static SmpTimeZone getSystemTimezone() {
        return systemTimezone;
    }
}

