/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.dao.LocationOrGroupTagRepository;
import com.netsync.smp.domain.AuditTrailActions;
import com.netsync.smp.domain.AuditTrailObjectTypes;
import com.netsync.smp.domain.LocationOrGroupTag;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.logic.ApplicationDataFacade;
import com.netsync.smp.logic.AuditTrailDataFacade;
import com.netsync.smp.web.security.CurrentUser;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.UsesJava8;
import org.springframework.stereotype.Component;

@Component
@UsesJava8
public class TagDataFacade {
    protected LocationOrGroupTagRepository repo;
    protected ApplicationDataFacade appFacade;
    protected AuditTrailDataFacade auditFacade;

    @Autowired
    public TagDataFacade(LocationOrGroupTagRepository repo, ApplicationDataFacade appFacade, AuditTrailDataFacade auditFacade) {
        this.repo = repo;
        this.appFacade = appFacade;
        this.auditFacade = auditFacade;
    }

    public Set<LocationOrGroupTag> getAll() {
        return new HashSet<LocationOrGroupTag>(this.repo.findAll());
    }

    public Set<LocationOrGroupTag> updateAll(Set<LocationOrGroupTag> incoming) throws SmpNotAuthorizedException, SmpIllegalDataException {
        if (!CurrentUser.isAdmin()) {
            throw new SmpNotAuthorizedException("Save tags");
        }
        Set existing = this.getAll();
        Set used = this.appFacade.getAllUniqueTagsInUse();
        HashSet<LocationOrGroupTag> toCreate = new HashSet<LocationOrGroupTag>(incoming);
        toCreate.removeAll(existing);
        toCreate.forEach(tag -> {
            this.auditFacade.LogAction(AuditTrailActions.Create, AuditTrailObjectTypes.Tag, tag.getName());
            this.repo.insert(tag);
        });
        HashSet toDelete = new HashSet(existing);
        toDelete.removeAll(incoming);
        toDelete.removeAll(used);
        toDelete.forEach(tag -> {
            this.auditFacade.LogAction(AuditTrailActions.Delete, AuditTrailObjectTypes.Tag, tag.getName());
            this.repo.delete(tag.getId());
        });
        return this.getAll();
    }
}

