/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.dao.RecordingStateRepository;
import com.netsync.smp.domain.StandardPromptGroup;
import com.netsync.smp.domain.UccxApplication;
import com.netsync.smp.domain.frontend.StartRecordingParams;
import com.netsync.smp.domain.uccx.CallTreatment;
import com.netsync.smp.domain.uccx.RecordingState;
import com.netsync.smp.domain.uccx.RecordingStatus;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.ApplicationDataFacade;
import com.netsync.smp.logic.CallTreatmentFacade;
import com.netsync.smp.web.config.UccxRecordingRestTemplate;
import com.netsync.smp.web.config.UccxWebApiConfig;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class UccxDataFacade {
    private static final Logger log = LoggerFactory.getLogger(UccxDataFacade.class);
    @Value(value="${smp.hostname}")
    protected String smpHostname;
    protected RecordingStateRepository repo;
    protected UccxRecordingRestTemplate uccxRecordingRest;
    protected ApplicationDataFacade applicationFacade;
    protected UccxWebApiConfig uccxWebApi;

    @Autowired
    public UccxDataFacade(RecordingStateRepository repo, UccxRecordingRestTemplate uccxRecordingRest, ApplicationDataFacade applicationFacade, UccxWebApiConfig uccxWebApi) {
        this.repo = repo;
        this.uccxRecordingRest = uccxRecordingRest;
        this.applicationFacade = applicationFacade;
        this.uccxWebApi = uccxWebApi;
    }

    public CallTreatment getCallTreatment(String trigger, Locale locale, String date) {
        log.info("Retrieving call treatment for application with trigger [" + trigger + "]");
        UccxApplication app = this.applicationFacade.findApplicationByTrigger(trigger);
        if (app == null) {
            log.warn("Application with trigger [" + trigger + "] not found in SMP database");
            return CallTreatment.empty();
        }
        log.trace("Application found for trigger [" + trigger + "]: [" + app + "]");
        log.info("Finding prompts for locale [" + locale + "]");
        Map localeToPromptMap = app.getStandardPrompts();
        if (localeToPromptMap == null) {
            log.error("Locale / Prompt mapping not found");
            return CallTreatment.empty();
        }
        StandardPromptGroup standardPromptGroup = (StandardPromptGroup)localeToPromptMap.get(locale);
        if (standardPromptGroup == null) {
            log.warn("Locale [" + locale + "] not found in SMP database for trigger [" + trigger + "]");
            return CallTreatment.empty();
        }
        try {
            return CallTreatmentFacade.determineCallTreatment((UccxApplication)app, (Locale)locale, (String)date);
        }
        catch (Exception e) {
            log.warn("Return Call Treatment threw an exception " + e.getMessage());
            return CallTreatment.empty();
        }
    }

    public RecordingState setRecordingStatus(String recording_id, RecordingStatus status) throws SmpNotFoundException, SmpIllegalDataException {
        RecordingState state = this.repo.findOneByRecordingId(recording_id);
        if (null == state) {
            throw new SmpNotFoundException(recording_id, "Recording Status");
        }
        if (RecordingStatus.Completed.equals((Object)state.getStatus())) {
            throw new SmpIllegalDataException("Recording id " + recording_id + " already completed");
        }
        state.setStatus(status);
        return this.repo.save(state);
    }

    public RecordingState startRecording(StartRecordingParams params) throws SmpIllegalDataException {
        String recordingId = UUID.randomUUID().toString();
        RecordingState state = this.repo.insert(new RecordingState(recordingId, RecordingStatus.Calling, params.getPromptName(), params.getLocale()));
        log.debug("Saved state to db: " + state);
        try {
            boolean result = this.uccxRecordingRest.callRecording(recordingId, params, this.smpHostname);
            if (result) {
                log.debug("callRecording - successful!");
            }
        }
        catch (Exception e) {
            log.debug("callRecording - NOT successful!");
        }
        return state;
    }

    public RecordingState getRecordingStatus(String recording_id) throws SmpNotFoundException {
        RecordingState state = this.repo.findOneByRecordingId(recording_id);
        if (null == state) {
            throw new SmpNotFoundException(recording_id, "Recording Status");
        }
        return state;
    }

    public byte[] getPromptFile(String locale, String name) throws SmpNotFoundException {
        try {
            if (!name.endsWith(".wav")) {
                name = name + ".wav";
            }
            ResponseEntity blob = this.uccxWebApi.getPromptByName(locale, name);
            return (byte[])blob.getBody();
        }
        catch (Exception e) {
            SmpNotFoundException snfe = new SmpNotFoundException(locale + "/" + name, "UCCX Prompts", (Throwable)e);
            log.error("getPromptFile: ", (Throwable)snfe);
            throw snfe;
        }
    }
}

