/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.logic;

import com.netsync.smp.dao.UserRepository;
import com.netsync.smp.domain.AuditTrailActions;
import com.netsync.smp.domain.AuditTrailObjectTypes;
import com.netsync.smp.domain.HashedPassword;
import com.netsync.smp.domain.User;
import com.netsync.smp.domain.frontend.PasswordResult;
import com.netsync.smp.domain.frontend.SmpPassword;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.AuditTrailDataFacade;
import com.netsync.smp.logic.UserDataFacade;
import com.netsync.smp.web.security.CurrentUser;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.pool.factory.PoolingContextSource;
import org.springframework.ldap.pool.validation.DefaultDirContextValidator;
import org.springframework.ldap.pool.validation.DirContextValidator;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.transaction.compensating.manager.TransactionAwareContextSourceProxy;
import org.springframework.stereotype.Component;

@Component
public class UserDataFacade {
    private static final Logger log = LoggerFactory.getLogger(UserDataFacade.class);
    @Value(value="${users.default_password}")
    protected String default_password;
    @Value(value="${users.password_regex}")
    protected String password_regex;
    @Value(value="${users.password_rules}")
    protected String password_rules;
    @Value(value="${ldap.domain}")
    protected String ldapDomain;
    @Value(value="${ldap.hostname}")
    protected String ldapHostname;
    @Value(value="${ldap.port}")
    protected String ldapPort;
    @Value(value="${ldap.base}")
    protected String ldapBase;
    @Value(value="${ldap.username}")
    protected String ldapUserDn;
    @Value(value="${ldap.password}")
    protected String ldapPassword;
    @Value(value="${ldap.url}")
    protected String ldapURL;
    @Value(value="${ldap.disabled:false}")
    protected boolean ldapDisabled;
    protected Pattern pattern;
    protected UserRepository repo;
    protected AuditTrailDataFacade auditFacade;

    @Autowired
    public UserDataFacade(UserRepository repo, AuditTrailDataFacade auditFacade) {
        this.repo = repo;
        this.auditFacade = auditFacade;
    }

    @PostConstruct
    protected void postConstruct() {
        this.pattern = Pattern.compile(this.password_regex);
    }

    protected boolean passwordIsDifficult(String clearPassword) {
        return this.pattern.matcher(clearPassword).matches();
    }

    protected void checkCreateOrUpdate(User user) throws SmpIllegalDataException, SmpNotAuthorizedException {
        if (null == user) {
            throw new SmpIllegalDataException("Must be a valid User object");
        }
        if (!CurrentUser.isAdmin()) {
            throw new SmpNotAuthorizedException("create or update users");
        }
    }

    @Bean
    public ContextSource ldapContextSource() {
        if (this.ldapDisabled) {
            log.error("ldapContextSource: LDAP is disabled.");
            return null;
        }
        log.info("Creating LdapContextSource()");
        String url = this.ldapURL;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.referral", "follow");
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(url);
        contextSource.setBase(this.ldapBase);
        contextSource.setUserDn(this.ldapUserDn);
        contextSource.setPassword(this.ldapPassword);
        contextSource.setBaseEnvironmentProperties(env);
        contextSource.afterPropertiesSet();
        log.info("LdapContextSource properties successfully set");
        log.info("Creating PoolingContextSource");
        PoolingContextSource poolingContextSource = new PoolingContextSource();
        poolingContextSource.setDirContextValidator((DirContextValidator)new DefaultDirContextValidator());
        poolingContextSource.setContextSource((ContextSource)contextSource);
        poolingContextSource.setTestOnBorrow(true);
        poolingContextSource.setTestWhileIdle(true);
        log.info("PoolingContextSource properties successfully set");
        TransactionAwareContextSourceProxy proxy = new TransactionAwareContextSourceProxy((ContextSource)poolingContextSource);
        log.info("Returning Proxy at end of LdapContextSource Constructor");
        return proxy;
    }

    @Bean
    public LdapTemplate ldapTemplate() {
        if (this.ldapDisabled) {
            log.error("ldapTemplate: LDAP is disabled.");
            return null;
        }
        return new LdapTemplate(this.ldapContextSource());
    }

    public boolean ldapUserExists(String userId) {
        if (this.ldapDisabled) {
            throw new RuntimeException("LDAP is disabled.");
        }
        List results = this.ldapTemplate().search((LdapQuery)LdapQueryBuilder.query().where("objectclass").is("person").and("sAMAccountName").is(userId), (AttributesMapper)new PersonAttributesMapper());
        return results != null && !results.isEmpty();
    }

    public List<Person> searchLdapUser(String userId) {
        if (this.ldapDisabled) {
            throw new RuntimeException("LDAP is disabled.");
        }
        log.info("Starting ldapUserExists check for " + userId);
        List temp = this.ldapTemplate().search((LdapQuery)LdapQueryBuilder.query().where("objectclass").is("person").and("sAMAccountName").whitespaceWildcardsLike(userId), (AttributesMapper)new PersonAttributesMapper());
        log.info("Finished ldapUserExists check for " + userId + " with # of results = " + temp.size());
        return temp;
    }

    public List<Person> getAllPersonNames() {
        if (this.ldapDisabled) {
            throw new RuntimeException("LDAP is disabled.");
        }
        return this.ldapTemplate().search((LdapQuery)LdapQueryBuilder.query().where("objectclass").is("person"), (AttributesMapper)new PersonAttributesMapper());
    }

    public User createLdap(User user) throws SmpIllegalDataException, SmpNotAuthorizedException {
        if (this.ldapDisabled) {
            throw new RuntimeException("LDAP is disabled.");
        }
        this.checkCreateOrUpdate(user);
        if (null != user.getId() && !user.getId().isEmpty()) {
            throw new SmpIllegalDataException("ID must be empty to create");
        }
        if (this.repo.findOneByUserId(user.getUserId()) != null) {
            throw new SmpIllegalDataException("ID already exists");
        }
        this.auditFacade.LogAction(AuditTrailActions.Create, AuditTrailObjectTypes.User, user.getUserId());
        return this.repo.insert(user);
    }

    public User createLocal(User user) throws SmpIllegalDataException, SmpNotAuthorizedException {
        this.checkCreateOrUpdate(user);
        if (null != user.getId() && !user.getId().isEmpty()) {
            throw new SmpIllegalDataException("ID must be empty to create");
        }
        if (this.repo.findOneByUserId(user.getUserId()) != null) {
            throw new SmpIllegalDataException("ID already exists");
        }
        user.setHashedPassword(HashedPassword.fromClear((String)this.default_password));
        this.auditFacade.LogAction(AuditTrailActions.Create, AuditTrailObjectTypes.User, user.getUserId());
        return this.repo.insert(user);
    }

    public PasswordResult changePassword(SmpPassword password) {
        if (!this.passwordIsDifficult(password.getPassword())) {
            return new PasswordResult(false, this.password_rules);
        }
        User current = CurrentUser.get();
        User databaseUser = this.findOneByUserId(current.getUserId());
        if (databaseUser.getHashedPassword() != null && databaseUser.getHashedPassword().getHash() != null && !databaseUser.getHashedPassword().getHash().isEmpty()) {
            databaseUser.setHashedPassword(HashedPassword.fromClear((String)password.getPassword()));
            this.auditFacade.LogAction(AuditTrailActions.Update, AuditTrailObjectTypes.User, databaseUser.getUserId());
            this.repo.save(databaseUser);
            return new PasswordResult(true, "");
        }
        return new PasswordResult(false, "Cannot change password for LDAP users");
    }

    public PasswordResult resetPassword(String userId) {
        User current = CurrentUser.get();
        User databaseUser = this.findOneById(userId);
        if (!current.isAdmin()) {
            return new PasswordResult(false, "Only admins can reset passwords.");
        }
        if (databaseUser.getHashedPassword() != null && databaseUser.getHashedPassword().getHash() != null && !databaseUser.getHashedPassword().getHash().isEmpty()) {
            databaseUser.setHashedPassword(HashedPassword.fromClear((String)this.default_password));
            this.auditFacade.LogAction(AuditTrailActions.Update, AuditTrailObjectTypes.User, databaseUser.getUserId());
            this.repo.save(databaseUser);
            return new PasswordResult(true, "");
        }
        return new PasswordResult(false, "You cannot change LDAP passwords.");
    }

    public User update(User user) throws SmpIllegalDataException, SmpNotAuthorizedException, SmpNotFoundException {
        return this.update(user.getId(), user);
    }

    public User update(String id, User user) throws SmpIllegalDataException, SmpNotAuthorizedException, SmpNotFoundException {
        this.checkCreateOrUpdate(user);
        if (id == null || id.isEmpty()) {
            throw new SmpIllegalDataException("ID must be valid to create");
        }
        if (!id.equals(user.getId())) {
            throw new SmpIllegalDataException("URL ID must match payload ID");
        }
        User existing = this.repo.findOneById(user.getId());
        if (null == existing) {
            throw new SmpNotFoundException(id, "Users");
        }
        if (null != existing.getHashedPassword()) {
            user.setHashedPassword(existing.getHashedPassword());
        }
        this.auditFacade.LogAction(AuditTrailActions.Update, AuditTrailObjectTypes.User, user.getUserId());
        return this.repo.save(user);
    }

    public List<User> findAll() {
        return this.repo.findAll();
    }

    public User findOneById(String id) {
        return this.repo.findOneById(id);
    }

    public User findOneByUserId(String userId) {
        log.info("Find user in database: " + userId);
        return this.repo.findOneByUserId(userId);
    }

    public void delete(String id) throws SmpNotAuthorizedException, SmpNotFoundException {
        if (!CurrentUser.isAdmin()) {
            throw new SmpNotAuthorizedException("delete users");
        }
        User user = this.findOneById(id);
        if (null == user) {
            throw new SmpNotFoundException(id, "Users");
        }
        this.repo.delete(id);
    }
}

