/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.config;

import com.netsync.smp.domain.ApplicationUserPermission;
import com.netsync.smp.domain.ApplicationUserPermissionArrayList;
import com.netsync.smp.domain.HolidayRule;
import com.netsync.smp.domain.HolidayRuleArrayList;
import com.netsync.smp.domain.HolidaySchema;
import com.netsync.smp.domain.HolidaySchemaArrayList;
import com.netsync.smp.domain.LocationOrGroupTag;
import com.netsync.smp.domain.LocationOrGroupTagArrayList;
import com.netsync.smp.domain.UccxApplication;
import com.netsync.smp.domain.UccxApplicationArrayList;
import com.netsync.smp.domain.User;
import com.netsync.smp.domain.UserArrayList;
import com.netsync.smp.domain.finesse.FinesseUserArrayList;
import com.netsync.smp.domain.informix.InformixPromptArrayList;
import com.netsync.smp.domain.informix.InformixTriggerAppArrayList;
import com.netsync.smp.domain.uccx.RecordingState;
import com.netsync.smp.web.config.CacheConfigSmp;
import com.netsync.smp.web.config.codehaus.JsonDeserializerLocalDate;
import com.netsync.smp.web.config.codehaus.JsonDeserializerLocalTime;
import com.netsync.smp.web.config.codehaus.JsonSerializerLocalDate;
import com.netsync.smp.web.config.codehaus.JsonSerializerLocalTime;
import java.time.LocalDate;
import java.time.LocalTime;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class CacheConfigSmp {
    @Value(value="${redis.url}")
    protected String cacheUrl;
    @Value(value="${redis.port}")
    protected int cachePort;
    @Value(value="${redis.timeout}")
    protected int cacheTimeout;
    protected static JedisConnectionFactory redisConnectionFactory;
    ObjectMapper objectMapper;

    public JedisConnectionFactory redisConnectionFactory() {
        if (null == redisConnectionFactory) {
            redisConnectionFactory = new JedisConnectionFactory();
            redisConnectionFactory.setHostName(this.cacheUrl);
            redisConnectionFactory.setPort(this.cachePort);
            redisConnectionFactory.setTimeout(this.cacheTimeout);
            redisConnectionFactory.setUsePool(true);
            redisConnectionFactory.setPoolConfig(new JedisPoolConfig());
            redisConnectionFactory.afterPropertiesSet();
        }
        return redisConnectionFactory;
    }

    public ObjectMapper objectMapper() {
        if (null == this.objectMapper) {
            this.objectMapper = new ObjectMapper();
            SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, null));
            simpleModule.addSerializer(LocalDate.class, (JsonSerializer)new JsonSerializerLocalDate());
            simpleModule.addSerializer(LocalTime.class, (JsonSerializer)new JsonSerializerLocalTime());
            simpleModule.addDeserializer(LocalDate.class, (JsonDeserializer)new JsonDeserializerLocalDate());
            simpleModule.addDeserializer(LocalTime.class, (JsonDeserializer)new JsonDeserializerLocalTime());
            this.objectMapper.registerModule((Module)simpleModule);
        }
        return this.objectMapper;
    }

    @Bean
    @Primary
    public CacheManager cacheManager() {
        return null;
    }

    @Bean
    public KeyGenerator customKeyGenerator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    CacheManager cacheEvictCacheManager() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.redisConnectionFactory());
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.afterPropertiesSet();
        RedisCacheManager cacheManager = new RedisCacheManager(redisTemplate);
        cacheManager.setUsePrefix(true);
        cacheManager.setDefaultExpiration(0L);
        return cacheManager;
    }

    @Bean
    public CacheManager applicationUserPermissionCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(ApplicationUserPermission.class);
    }

    @Bean
    public CacheManager applicationUserPermissionListCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(ApplicationUserPermissionArrayList.class);
    }

    @Bean
    public CacheManager holidayRuleCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(HolidayRule.class);
    }

    @Bean
    public CacheManager holidayRuleListCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(HolidayRuleArrayList.class);
    }

    @Bean
    public CacheManager holidaySchemaCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(HolidaySchema.class);
    }

    @Bean
    public CacheManager holidaySchemaListCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(HolidaySchemaArrayList.class);
    }

    @Bean
    public CacheManager uccxApplicationCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(UccxApplication.class);
    }

    @Bean
    public CacheManager uccxApplicationListCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(UccxApplicationArrayList.class);
    }

    @Bean
    public CacheManager userCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(User.class);
    }

    @Bean
    public CacheManager userListCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(UserArrayList.class);
    }

    @Bean
    public CacheManager recordingStateCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(RecordingState.class);
    }

    @Bean
    public CacheManager finesseUserArrayListCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(FinesseUserArrayList.class);
    }

    @Bean
    public CacheManager informixTriggerAppArrayListCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(InformixTriggerAppArrayList.class);
    }

    @Bean
    public CacheManager informixPromptArrayListCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(InformixPromptArrayList.class);
    }

    @Bean
    public CacheManager locationOrGroupTagCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(LocationOrGroupTag.class);
    }

    @Bean
    public CacheManager locationOrGroupTagArrayListCacheManager() {
        return new TemplatedCacheManager(this).cacheManager(LocationOrGroupTagArrayList.class);
    }

    @Bean
    public KeyGenerator recordingStateKeyGenerator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

