/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.config;

import com.netsync.smp.exception.SmpInvalidConfigPropertyException;
import com.netsync.smp.web.config.MySimpleClientHttpRequestFactory;
import com.netsync.smp.web.config.NullHostnameVerifier;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class FinesseRestTemplate
extends RestTemplate {
    @Value(value="${finesse.url}")
    private String finesseUrl;
    @Value(value="${finesse.port}")
    private Integer finessePort;
    @Value(value="${finesse.timeout}")
    private Integer finesseTimeout;
    @Value(value="${finesse.readOnlyAdmin.username}")
    private String finesseAdminUsername;
    @Value(value="${finesse.readOnlyAdmin.password}")
    private String finesseAdminPassword;
    private String finesseFullUrl = "";
    MySimpleClientHttpRequestFactory factory;

    @PostConstruct
    protected void postConstruct() throws SmpInvalidConfigPropertyException {
        if (this.finesseUrl == null || this.finesseUrl.isEmpty()) {
            throw new SmpInvalidConfigPropertyException("${finesse.url}", (Object)this.finesseUrl, "Must have non-empty value.");
        }
        if (!this.finesseUrl.startsWith("http://") && !this.finesseUrl.startsWith("https://")) {
            throw new SmpInvalidConfigPropertyException("${uccx_recording.url}", (Object)this.finesseUrl, "Must start with either 'http://' or 'https://'.");
        }
        if (this.finessePort == null || this.finessePort < 1024 || this.finessePort > 65535) {
            throw new SmpInvalidConfigPropertyException("${finesse.port}", (Object)this.finessePort, "Must be valid port value.");
        }
        if (this.finesseTimeout == null || this.finesseTimeout < 0 || this.finesseTimeout > 10000) {
            throw new SmpInvalidConfigPropertyException("${finesse.timeout}", (Object)this.finesseTimeout, "Must have non-empty value between 0 and 10000 (10 seconds)");
        }
        if (this.finesseAdminUsername == null || this.finesseAdminUsername.isEmpty()) {
            throw new SmpInvalidConfigPropertyException("${finesse.readOnlyAdmin.username}", (Object)this.finesseAdminUsername, "Must have non-empty value.");
        }
        if (this.finesseAdminPassword == null || this.finesseAdminPassword.isEmpty()) {
            throw new SmpInvalidConfigPropertyException("${finesse.readOnlyAdmin.password}", (Object)this.finesseAdminPassword, "Must have non-empty value.");
        }
        this.finesseFullUrl = this.finesseUrl + ":" + Integer.toString(this.finessePort) + "/";
        MySimpleClientHttpRequestFactory factory = new MySimpleClientHttpRequestFactory((HostnameVerifier)new NullHostnameVerifier());
        factory.setReadTimeout(this.finesseTimeout.intValue());
        factory.setConnectTimeout(this.finesseTimeout.intValue());
        super.setRequestFactory((ClientHttpRequestFactory)factory);
    }

    public <T> ResponseEntity<T> callGet(String appendUrl, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return this.exchange(this.finesseFullUrl + appendUrl, HttpMethod.GET, requestEntity, responseType, uriVariables);
    }

    public String getFinesseAdminUsername() {
        return this.finesseAdminUsername;
    }

    public String getFinesseAdminPassword() {
        return this.finesseAdminPassword;
    }
}

