/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.config;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class InformixConfig {
    @Value(value="${spring.datasource.informix_cra.url}")
    protected String craUrl;
    @Value(value="${spring.datasource.informix_cra.driverClassName}")
    protected String craDriverClassName;
    @Value(value="${spring.datasource.informix_cra.username}")
    protected String craUsername;
    @Value(value="${spring.datasource.informix_cra.password}")
    protected String craPassword;
    @Value(value="${spring.datasource.informix_cra.max_pool_size:5}")
    protected int craMaxPoolSize;
    @Value(value="${spring.datasource.informix_cra_repository.url}")
    protected String craRepositoryUrl;
    @Value(value="${spring.datasource.informix_cra_repository.driverClassName}")
    protected String craRepositoryDriverClassName;
    @Value(value="${spring.datasource.informix_cra_repository.username}")
    protected String craRepositoryUsername;
    @Value(value="${spring.datasource.informix_cra_repository.password}")
    protected String craRepositoryPassword;
    @Value(value="${spring.datasource.informix_cra_repository.max_pool_size:5}")
    protected int craRepositoryMaxPoolSize;
    @Value(value="${spring.datasource.informix_timeout_seconds}")
    protected int informix_timeout_seconds;

    @Bean(name={"informixDataSourceCraHikari"})
    @Primary
    public DataSource dataSource() {
        HikariDataSource ds = new HikariDataSource();
        ds.setMaximumPoolSize(this.craMaxPoolSize);
        ds.setDriverClassName(this.craDriverClassName);
        ds.setJdbcUrl(this.craUrl);
        ds.setUsername(this.craUsername);
        ds.setPassword(this.craPassword);
        ds.setDataSourceProperties(this.databaseNameProperty(this.craUrl));
        return ds;
    }

    @Bean(name={"informixJdbcTemplateCra"})
    @Primary
    @Autowired
    public JdbcTemplate informixJdbcTemplateCra(@Qualifier(value="informixDataSourceCraHikari") DataSource informixDataSource) throws SQLException {
        informixDataSource.setLoginTimeout(this.informix_timeout_seconds);
        return new JdbcTemplate(informixDataSource);
    }

    @Bean(name={"informixDataSourceCraRepositoryHikari"})
    public DataSource dataSourceRepository() {
        HikariDataSource ds = new HikariDataSource();
        ds.setMaximumPoolSize(this.craRepositoryMaxPoolSize);
        ds.setDriverClassName(this.craRepositoryDriverClassName);
        ds.setJdbcUrl(this.craRepositoryUrl);
        ds.setUsername(this.craRepositoryUsername);
        ds.setPassword(this.craRepositoryPassword);
        ds.setDataSourceProperties(this.databaseNameProperty(this.craRepositoryUrl));
        return ds;
    }

    @Bean(name={"informixJdbcTemplateCraRepository"})
    @Autowired
    public JdbcTemplate informixJdbcTemplateCraRepository(@Qualifier(value="informixDataSourceCraRepositoryHikari") DataSource informixDataSource) throws SQLException {
        informixDataSource.setLoginTimeout(this.informix_timeout_seconds);
        return new JdbcTemplate(informixDataSource);
    }

    private Properties databaseNameProperty(String dbUrl) {
        Properties props = new Properties();
        int lastForwardSlashIndex = dbUrl.lastIndexOf("/");
        if (lastForwardSlashIndex == -1 || dbUrl.length() <= lastForwardSlashIndex + 1) {
            throw new IllegalArgumentException("Unable to determine the database name from the database URL.");
        }
        props.setProperty("DATABASE", dbUrl.substring(lastForwardSlashIndex + 1));
        return props;
    }
}

