/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.config;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.WriteConcern;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.config.AbstractMongoConfiguration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
public class MongoConfig
extends AbstractMongoConfiguration {
    @Value(value="${mongo.database}")
    protected String dbDatabase;
    @Value(value="${mongo.url}")
    protected String dbUrl;
    @Value(value="${mongo.port}")
    protected int dbPort;
    @Value(value="${mongo.username}")
    protected String dbUsername;
    @Value(value="${mongo.password}")
    protected String dbPassword;

    public String getDatabaseName() {
        return this.dbDatabase;
    }

    @Bean
    public Mongo mongo() throws Exception {
        return new MongoClient(this.dbUrl, this.dbPort);
    }

    @Bean
    public MongoTemplate mongoTemplate() throws Exception {
        UserCredentials userCredentials = new UserCredentials(this.dbUsername, this.dbPassword);
        MongoTemplate mongoTemplate = new MongoTemplate(this.mongo(), this.getDatabaseName(), userCredentials);
        mongoTemplate.setWriteConcern(WriteConcern.SAFE);
        return mongoTemplate;
    }
}

