/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.config;

import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.valves.RemoteIpValve;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"prod"})
public class ProductionTomcatConfig {
    @Value(value="${tomcat.ajpPort}")
    protected int ajpPort;
    @Value(value="${tomcat.redirectPort}")
    protected int redirectPort;

    @Bean
    public EmbeddedServletContainerFactory servletContainer() {
        TomcatEmbeddedServletContainerFactory tomcat = new TomcatEmbeddedServletContainerFactory();
        tomcat.addAdditionalTomcatConnectors(new Connector[]{this.getAjpConnector()});
        tomcat.addContextValves(new Valve[]{this.getRemoteIpValve()});
        return tomcat;
    }

    private RemoteIpValve getRemoteIpValve() {
        RemoteIpValve valve = new RemoteIpValve();
        valve.setRemoteIpHeader("x-forwarded-for");
        valve.setProtocolHeader("x-forwarded-protocol");
        return valve;
    }

    private Connector getAjpConnector() {
        Connector connector = new Connector("org.apache.coyote.ajp.AjpProtocol");
        connector.setScheme("ajp");
        connector.setProtocol("AJP/1.3");
        connector.setRedirectPort(this.redirectPort);
        connector.setPort(this.ajpPort);
        return connector;
    }
}

