/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.config;

import com.netsync.smp.domain.frontend.StartRecordingParams;
import com.netsync.smp.exception.SmpInvalidConfigPropertyException;
import com.netsync.smp.web.config.MySimpleClientHttpRequestFactory;
import com.netsync.smp.web.config.NullHostnameVerifier;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class UccxRecordingRestTemplate
extends RestTemplate {
    @Value(value="${uccx_recording.url}")
    protected String uccxRecordingUrl;
    @Value(value="${uccx_recording.port}")
    protected Integer uccxRecordingPort;
    @Value(value="${uccx_recording.timeout}")
    protected Integer uccxRecordingTimeout;
    @Value(value="${uccx_recording.recording_endpoint}")
    protected String uccxRecordingEndpoint;
    protected String uccxBaseUri = "";
    protected String uccxRecordingFullUri = "";
    MySimpleClientHttpRequestFactory factory;

    @PostConstruct
    protected void postConstruct() throws SmpInvalidConfigPropertyException {
        if (this.uccxRecordingUrl == null || this.uccxRecordingUrl.isEmpty()) {
            throw new SmpInvalidConfigPropertyException("${uccx_recording.url}", (Object)this.uccxRecordingUrl, "Must have non-empty value.");
        }
        if (!this.uccxRecordingUrl.startsWith("http://") && !this.uccxRecordingUrl.startsWith("https://")) {
            throw new SmpInvalidConfigPropertyException("${uccx_recording.url}", (Object)this.uccxRecordingUrl, "Must start with either 'http://' or 'https://'.");
        }
        if (this.uccxRecordingPort == null || this.uccxRecordingPort < 1024 || this.uccxRecordingPort > 65535) {
            throw new SmpInvalidConfigPropertyException("${uccx_recording.port}", (Object)this.uccxRecordingPort, "Must be valid port value.");
        }
        if (this.uccxRecordingTimeout == null || this.uccxRecordingTimeout < 0 || this.uccxRecordingTimeout > 10000) {
            throw new SmpInvalidConfigPropertyException("${uccx_recording.timeout}", (Object)this.uccxRecordingTimeout, "Must have non-empty value between 0 and 10000 (10 seconds)");
        }
        if (this.uccxRecordingEndpoint == null || this.uccxRecordingEndpoint.isEmpty()) {
            throw new SmpInvalidConfigPropertyException("${uccx_recording.recording_endpoint}", (Object)this.uccxRecordingEndpoint, "Must have non-empty value.");
        }
        if (this.uccxRecordingEndpoint.startsWith("/")) {
            this.uccxRecordingEndpoint.replaceFirst("/", "");
        }
        this.uccxBaseUri = this.uccxRecordingUrl + ":" + Integer.toString(this.uccxRecordingPort) + "/";
        this.uccxRecordingFullUri = this.uccxBaseUri + this.uccxRecordingEndpoint;
        MySimpleClientHttpRequestFactory factory = new MySimpleClientHttpRequestFactory((HostnameVerifier)new NullHostnameVerifier());
        factory.setReadTimeout(this.uccxRecordingTimeout.intValue());
        factory.setConnectTimeout(this.uccxRecordingTimeout.intValue());
        super.setRequestFactory((ClientHttpRequestFactory)factory);
    }

    public boolean callRecording(String recordingId, StartRecordingParams params, String smpHostname) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.uccxRecordingFullUri).queryParam("ID", new Object[]{recordingId}).queryParam("language", new Object[]{params.getLocale()}).queryParam("promptname", new Object[]{params.getPromptName()}).queryParam("numbertodial", new Object[]{params.getNumberToCall()}).queryParam("hostname", new Object[]{smpHostname});
        String url = builder.build().encode().toUri().toString();
        System.out.println("Calling " + url);
        HttpStatus statusResponse = this.getForEntity(url, Object.class, new Object[0]).getStatusCode();
        System.out.println("Response Status Code: " + statusResponse);
        return statusResponse.is2xxSuccessful();
    }

    public String getUccxBaseUri() {
        return this.uccxBaseUri;
    }

    public String getUccxRecordingFullUri() {
        return this.uccxRecordingFullUri;
    }
}

