/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.config;

import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Configuration
public class UccxWebApiConfig
extends RestTemplate {
    @Value(value="${uccx.url}")
    protected String url;
    @Value(value="${uccx.port}")
    protected Integer port;
    @Value(value="${uccx.timeout}")
    protected Integer timeout;
    @Value(value="${uccx.username}")
    protected String username;
    @Value(value="${uccx.password}")
    protected String password;
    protected String baseUri = "";

    @PostConstruct
    protected void postConstruct() {
        this.baseUri = this.url + ":" + this.port;
    }

    private HttpHeaders basicHeaderAuth() {
        String plainCreds = this.username + ":" + this.password;
        String base64Creds = new String(Base64.encodeBase64((byte[])plainCreds.getBytes()));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Creds);
        return headers;
    }

    public ResponseEntity<byte[]> getPromptByName(String locale, String name) {
        HttpHeaders headers = this.basicHeaderAuth();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM));
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = this.baseUri + "/adminapi/prompt/download/" + locale + "/" + name;
        return this.exchange(url, HttpMethod.GET, request, byte[].class, new Object[0]);
    }

    public String getBaseUri() {
        return this.baseUri;
    }
}

