/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.config.fasterxml;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.SimpleTimeZone;
import org.springframework.stereotype.Component;

@Component
public class JsonSerializerInstant
extends JsonSerializer<Instant> {
    private static final String SECONDS_MILLISECONDS = ":ss";
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static ZoneId zid = null;

    public void serialize(Instant instant, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (null == zid) {
            zid = SimpleTimeZone.getDefault().toZoneId();
        }
        ZonedDateTime ldt = ZonedDateTime.ofInstant(instant, zid);
        gen.writeString(formatter.format(ldt));
    }
}

