/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.domain.ApplicationUserPermission;
import com.netsync.smp.domain.UccxApplication;
import com.netsync.smp.domain.frontend.LicenseValidity;
import com.netsync.smp.domain.frontend.SmpDatabaseId;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpInvalidLicenseException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.ApplicationDataFacade;
import com.netsync.smp.logic.SettingsDataFacade;
import com.netsync.smp.web.controller.BaseController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/applications"})
public class ApplicationsController
extends BaseController {
    protected ApplicationDataFacade appFacade;
    protected SettingsDataFacade settingsFacade;

    @Autowired
    public ApplicationsController(ApplicationDataFacade appFacade, SettingsDataFacade settingsFacade) {
        this.appFacade = appFacade;
        this.settingsFacade = settingsFacade;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public List<ApplicationUserPermission> getAllApplications() {
        return this.appFacade.findAll();
    }

    @RequestMapping(value={"/{id}/users"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public List<ApplicationUserPermission> getAllApplicationUsers(@PathVariable String id) throws SmpNotFoundException {
        return this.appFacade.findUsers(id);
    }

    @RequestMapping(value={"/{id}/users"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public List<ApplicationUserPermission> saveApplicationUsers(@PathVariable String id, @RequestBody List<ApplicationUserPermission> perms) throws SmpNotFoundException, SmpNotAuthorizedException {
        return this.appFacade.saveUsers(id, perms);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public ApplicationUserPermission getApplicationForId(@PathVariable String id) throws SmpNotFoundException {
        return this.appFacade.findOneById(id);
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, consumes={"application/json"})
    @Secured(value={"ROLE_ADMIN"})
    @ResponseStatus(value=HttpStatus.OK)
    public SmpDatabaseId createApplication(@RequestBody UccxApplication app) throws SmpInvalidLicenseException {
        try {
            LicenseValidity licenseValidity = this.settingsFacade.getLicenseValidity();
            if (!licenseValidity.isValid()) {
                throw new SmpInvalidLicenseException();
            }
        }
        catch (Exception e) {
            throw new SmpInvalidLicenseException();
        }
        return this.appFacade.create(app);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_USER"})
    public SmpDatabaseId updateApplication(@PathVariable String id, @RequestBody UccxApplication app) throws SmpIllegalDataException, SmpNotAuthorizedException {
        return this.appFacade.update(id, app);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @Secured(value={"ROLE_ADMIN"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteApplicationForId(@PathVariable String id) throws SmpNotAuthorizedException, SmpNotFoundException {
        this.appFacade.delete(id);
    }
}

