/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.domain.AuditEntry;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.AuditTrailDataFacade;
import java.time.Instant;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/audit"})
public class AuditController {
    protected AuditTrailDataFacade auditFacade;

    @Autowired
    public AuditController(AuditTrailDataFacade auditFacade) {
        this.auditFacade = auditFacade;
    }

    @RequestMapping(value={"/now"}, method={RequestMethod.GET})
    public Instant getInstant() {
        return Instant.now();
    }

    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    public ResponseEntity<List<AuditEntry>> getAll() {
        return new ResponseEntity((Object)this.auditFacade.findAll(), HttpStatus.OK);
    }

    @RequestMapping(value={"/count/{count}"}, method={RequestMethod.GET})
    public ResponseEntity<List<AuditEntry>> getAuditCount(@PathVariable int count) {
        return new ResponseEntity((Object)this.auditFacade.getMostRecent(count), HttpStatus.OK);
    }

    @RequestMapping(value={"/id/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<AuditEntry> getAuditEntry(@PathVariable String id) {
        try {
            return new ResponseEntity((Object)this.auditFacade.findOneById(id), HttpStatus.OK);
        }
        catch (SmpNotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/{fromSec}/{toSec}"}, method={RequestMethod.GET})
    public ResponseEntity<List<AuditEntry>> getAuditDate(@PathVariable int fromSec, @PathVariable int toSec) {
        return new ResponseEntity((Object)this.auditFacade.getBetweenDates(Instant.ofEpochSecond(fromSec), Instant.ofEpochSecond(toSec)), HttpStatus.OK);
    }
}

