/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.exception.SmpError;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpInvalidLicenseException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api"})
public abstract class BaseController {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);

    @ExceptionHandler(value={SmpIllegalDataException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    public void handle(SmpIllegalDataException e) {
        log.warn("SmpIllegalDataException: " + e.getMessage());
    }

    @ExceptionHandler(value={SmpNotAuthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public void handle(SmpNotAuthorizedException e) {
        log.warn("SmpNotAuthorizedException: " + e.getMessage());
    }

    @ExceptionHandler(value={SmpInvalidLicenseException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public SmpError handle(SmpInvalidLicenseException e) {
        log.warn("SmpInvalidLicenseException: " + e.getMessage());
        return new SmpError("LICENSE_INVALID", "The current license key is invalid.");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public void handle(Exception e) {
        log.warn("Exception: ", (Throwable)e);
    }
}

