/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.domain.uccx.CallTreatment;
import com.netsync.smp.logic.UccxDataFacade;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/call_treatment"})
public class CallTreatmentController {
    private static final Logger log = LoggerFactory.getLogger(CallTreatmentController.class);
    protected UccxDataFacade uccxFacade;

    @Autowired
    public CallTreatmentController(UccxDataFacade uccxFacade) {
        this.uccxFacade = uccxFacade;
    }

    @RequestMapping(value={"{trigger}/{locale}"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public CallTreatment getCallTreatment(@PathVariable String trigger, @PathVariable Locale locale) {
        log.info("getCallTreatment 1");
        return this.uccxFacade.getCallTreatment(trigger, locale, "");
    }

    @RequestMapping(value={"{trigger}/{locale}/{date}"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public CallTreatment getCallTreatment(@PathVariable String trigger, @PathVariable Locale locale, @PathVariable String date) {
        log.info("getCallTreatment 2");
        return this.uccxFacade.getCallTreatment(trigger, locale, date);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public CallTreatment getInvalidEndpointWithSlash() {
        return CallTreatment.empty();
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public CallTreatment getInvalidEndpointWithoutSlash() {
        return CallTreatment.empty();
    }

    @RequestMapping(value={"{trigger}/{locale}/{date}/**"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public CallTreatment getInvalidEndpoint() {
        return CallTreatment.empty();
    }

    @RequestMapping(value={"{trigger}"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public CallTreatment getInvalidEndpointOneParam() {
        return CallTreatment.empty();
    }
}

