/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.domain.HolidayRule;
import com.netsync.smp.domain.frontend.SmpDatabaseId;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.HolidayRuleDataFacade;
import com.netsync.smp.web.controller.BaseController;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/holidayRules"})
public class HolidayRulesController
extends BaseController {
    private HolidayRuleDataFacade holidayRuleFacade;

    @Autowired
    public HolidayRulesController(HolidayRuleDataFacade holidayRuleFacade) {
        this.holidayRuleFacade = holidayRuleFacade;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<HolidayRule> getAllHolidayRules() {
        return this.holidayRuleFacade.getAllHolidayRules();
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public HolidayRule getHolidayRuleForId(@PathVariable String id) throws SmpNotFoundException {
        return this.holidayRuleFacade.findOneById(id);
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, consumes={"application/json"})
    @Secured(value={"ROLE_ADMIN"})
    @ResponseStatus(value=HttpStatus.OK)
    public SmpDatabaseId createHolidayRule(@RequestBody HolidayRule holidayRule) throws SmpIllegalDataException, SmpNotAuthorizedException {
        return this.holidayRuleFacade.create(holidayRule);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @Secured(value={"ROLE_ADMIN"})
    @ResponseStatus(value=HttpStatus.OK)
    public SmpDatabaseId updateHolidayRule(@PathVariable String id, @RequestBody HolidayRule holidayRule) throws SmpIllegalDataException, SmpNotAuthorizedException {
        return this.holidayRuleFacade.update(id, holidayRule, Boolean.valueOf(true));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @Secured(value={"ROLE_ADMIN"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteHolidayRuleForId(@PathVariable String id) throws SmpNotAuthorizedException, SmpIllegalDataException {
        this.holidayRuleFacade.delete(id);
    }
}

