/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.domain.HolidaySchema;
import com.netsync.smp.domain.frontend.SmpDatabaseId;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.HolidayRuleDataFacade;
import com.netsync.smp.logic.HolidaySchemaDataFacade;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/holiday_schemas"})
public class HolidaySchemasController {
    protected HolidaySchemaDataFacade schemaFacade;
    protected HolidayRuleDataFacade holidayRuleFacade;

    @Autowired
    public HolidaySchemasController(HolidaySchemaDataFacade schemaFacade, HolidayRuleDataFacade holidayRuleFacade) {
        this.schemaFacade = schemaFacade;
        this.holidayRuleFacade = holidayRuleFacade;
    }

    @RequestMapping(value={"/{holidaySchemaId}/addHolidayRule/{holidayRuleId}"}, method={RequestMethod.GET})
    @Secured(value={"ROLE_ADMIN"})
    @ResponseStatus(value=HttpStatus.OK)
    public SmpDatabaseId addHolidayRuleToHolidaySchema(@PathVariable String holidaySchemaId, @PathVariable String holidayRuleId) throws SmpNotFoundException, SmpIllegalDataException, SmpNotAuthorizedException {
        return this.holidayRuleFacade.addHolidayRuleToHolidaySchema(holidaySchemaId, holidayRuleId);
    }

    @RequestMapping(value={"/{holidaySchemaId}/removeHolidayRule/{holidayRuleId}"}, method={RequestMethod.DELETE})
    @Secured(value={"ROLE_ADMIN"})
    @ResponseStatus(value=HttpStatus.OK)
    public SmpDatabaseId removeHolidayRuleFromHolidaySchema(@PathVariable String holidaySchemaId, @PathVariable String holidayRuleId) throws SmpNotFoundException, SmpIllegalDataException, SmpNotAuthorizedException {
        return this.holidayRuleFacade.removeHolidayRuleFromHolidaySchema(holidaySchemaId, holidayRuleId);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<HolidaySchema> getAllHolidaySchemas() {
        return this.schemaFacade.findAll();
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public HolidaySchema getHolidaySchemaForId(@PathVariable String id) {
        return this.schemaFacade.findOneById(id);
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, consumes={"application/json"})
    @Secured(value={"ROLE_ADMIN"})
    @ResponseStatus(value=HttpStatus.OK)
    public SmpDatabaseId createHolidaySchema(@RequestBody HolidaySchema schema) throws SmpIllegalDataException, SmpNotAuthorizedException {
        return this.schemaFacade.create(schema);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @Secured(value={"ROLE_ADMIN"})
    @ResponseStatus(value=HttpStatus.OK)
    public SmpDatabaseId updateHolidaySchema(@PathVariable String id, @RequestBody HolidaySchema schema) throws SmpIllegalDataException, SmpNotAuthorizedException {
        return this.schemaFacade.update(id, schema, Boolean.valueOf(true));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @Secured(value={"ROLE_ADMIN"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteHolidaySchemaForId(@PathVariable String id) throws SmpNotAuthorizedException, SmpIllegalDataException {
        this.schemaFacade.delete(id);
    }
}

