/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.domain.SmpVersion;
import com.netsync.smp.domain.frontend.Alert;
import com.netsync.smp.domain.frontend.LdapStatus;
import com.netsync.smp.domain.frontend.LicenseKey;
import com.netsync.smp.domain.frontend.LicenseValidity;
import com.netsync.smp.domain.frontend.SmpDateTime;
import com.netsync.smp.domain.frontend.SmpTimeZone;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.logic.SettingsDataFacade;
import com.netsync.smp.web.controller.BaseController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/settings"})
public class SettingsController
extends BaseController {
    protected SettingsDataFacade settingsFacade;

    @Autowired
    SettingsController(SettingsDataFacade settingsFacade) {
        this.settingsFacade = settingsFacade;
    }

    @RequestMapping(value={"/ldap/status"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public LdapStatus getLdapStatus() {
        return new LdapStatus(!this.settingsFacade.isLdapDisabled());
    }

    @RequestMapping(value={"/license"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public LicenseKey getLicenseKey() {
        return this.settingsFacade.getLicenseKey();
    }

    @RequestMapping(value={"/license"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_ADMIN"})
    public void setLicenseKey(@RequestParam LicenseKey licenseKey) throws SmpNotAuthorizedException {
        this.settingsFacade.setLicenseKey(licenseKey);
    }

    @RequestMapping(value={"/license/validity"})
    @ResponseStatus(value=HttpStatus.OK)
    public LicenseValidity getLicenseValidity() {
        return this.settingsFacade.getLicenseValidity();
    }

    @RequestMapping(value={"/alerts"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<Alert> getAlerts() {
        return this.settingsFacade.getAlerts();
    }

    @RequestMapping(value={"/version"})
    @ResponseStatus(value=HttpStatus.OK)
    public SmpVersion getVersion() {
        return this.settingsFacade.getVersion();
    }

    @RequestMapping(value={"/timezone"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public SmpTimeZone getTimeZone() {
        return SettingsDataFacade.getSystemTimezone();
    }

    @RequestMapping(value={"/datetime"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public SmpDateTime getDateTime() {
        return this.settingsFacade.getSystemDatetime();
    }
}

