/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.domain.LocationOrGroupTag;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.logic.TagDataFacade;
import com.netsync.smp.web.controller.BaseController;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tags"})
public class TagController
extends BaseController {
    protected TagDataFacade tagFacade;

    @Autowired
    public TagController(TagDataFacade tagFacade) {
        this.tagFacade = tagFacade;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_USER"})
    public Set<LocationOrGroupTag> getAll() {
        return this.tagFacade.getAll();
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_ADMIN"})
    public Set<LocationOrGroupTag> updateAll(@RequestBody Set<LocationOrGroupTag> tags) throws SmpNotAuthorizedException, SmpIllegalDataException {
        return this.tagFacade.updateAll(tags);
    }
}

