/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.domain.finesse.FinesseUser;
import com.netsync.smp.domain.frontend.StartRecordingParams;
import com.netsync.smp.domain.frontend.UccxLocaleItem;
import com.netsync.smp.domain.informix.InformixPrompt;
import com.netsync.smp.domain.informix.InformixTriggerApp;
import com.netsync.smp.domain.uccx.RecordingState;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.FinesseDataFacade;
import com.netsync.smp.logic.InformixDataFacade;
import com.netsync.smp.logic.UccxDataFacade;
import com.netsync.smp.web.controller.BaseController;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/uccx"})
public class UccxController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(UccxController.class);
    protected UccxDataFacade uccxFacade;
    protected InformixDataFacade informixFacade;
    protected FinesseDataFacade finesseFacade;

    @Autowired
    public UccxController(UccxDataFacade uccxFacade, InformixDataFacade informixFacade, FinesseDataFacade finesseFacade) {
        this.uccxFacade = uccxFacade;
        this.informixFacade = informixFacade;
        this.finesseFacade = finesseFacade;
    }

    @RequestMapping(value={"start_recording"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public RecordingState startRecording(@RequestBody StartRecordingParams params) throws SmpIllegalDataException {
        RecordingState state = this.uccxFacade.startRecording(params);
        log.debug("startRecording, state: " + state);
        return state;
    }

    @RequestMapping(value={"apps_triggers"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public List<InformixTriggerApp> getAppNames() throws SmpNotFoundException {
        return this.informixFacade.findAppsTriggers();
    }

    @RequestMapping(value={"apps_triggers"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void clearAppNames() {
        this.informixFacade.clearAppsTriggers();
    }

    @RequestMapping(value={"user_names"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public List<FinesseUser> getUserNames() throws SmpNotFoundException {
        return this.finesseFacade.findUserNames();
    }

    @RequestMapping(value={"user_names"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void clearUserNames() {
        this.finesseFacade.clearUserNames();
    }

    @RequestMapping(value={"locales"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, UccxLocaleItem> getLocales() throws SmpNotFoundException {
        return this.informixFacade.findLocales();
    }

    @RequestMapping(value={"prompts"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, List<InformixPrompt>> getPrompts() throws SmpNotFoundException {
        return this.informixFacade.findPrompts();
    }

    @RequestMapping(value={"prompt/{locale}/{name}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public byte[] getPrompt(@PathVariable String locale, @PathVariable String name) throws SmpNotFoundException {
        return this.uccxFacade.getPromptFile(locale, name);
    }

    @RequestMapping(value={"/call_recording/{recording_id}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public RecordingState getRecordingStatus(@PathVariable String recording_id) throws SmpNotFoundException {
        return this.uccxFacade.getRecordingStatus(recording_id);
    }

    @RequestMapping(value={"prompts"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void clearPrompts() {
        this.informixFacade.clearPrompts();
    }
}

