/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.logic.SettingsDataFacade;
import com.netsync.smp.web.controller.BaseController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/api/update"})
public class UpdateController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(UpdateController.class);
    @Autowired
    protected SettingsDataFacade settingsFacade;
    @Value(value="${update.script}")
    protected String updateScript;
    @Value(value="${LicenseKey}")
    protected String key;
    protected static boolean updateInProcess = false;
    private static String tmpUpdateDir = "/tmp/smp-update";
    private Process updateProcess;

    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    public Map<String, Object> checkForUpdate() throws IOException {
        Map latestVersion = this.settingsFacade.determineLatestVersion();
        if (latestVersion == null) {
            throw new RuntimeException("Could not fetch latest version details");
        }
        if (Boolean.FALSE.equals(latestVersion.get("licenseValid")) || Boolean.FALSE.equals(latestVersion.get("licenceValid"))) {
            return Collections.singletonMap("error", "LICENSE_EXPIRED");
        }
        if (Boolean.FALSE.equals(latestVersion.get("updateAvailable"))) {
            return Collections.singletonMap("newVersion", false);
        }
        return Collections.singletonMap("newVersion", latestVersion.get("latestVersion"));
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public boolean startUpdate() throws IOException {
        if (this.canStartUpdate()) {
            this.runUpdateScript();
            return true;
        }
        log.info("Cannot update application. Update already running.");
        return false;
    }

    @RequestMapping(value={"/is-running"}, method={RequestMethod.GET})
    public boolean checkStatus() throws IOException {
        return this.isUpdateInProcess();
    }

    @RequestMapping(value={"/stop"}, method={RequestMethod.GET})
    public boolean stop() {
        this.updateProcess.destroy();
        return true;
    }

    protected void runUpdateScript() {
        Map latestVersion = this.settingsFacade.determineLatestVersion();
        String downloadUrl = latestVersion.get("downloadUrl").toString();
        log.info("Beginning update with version from: " + downloadUrl);
        if (!this.downloadAndUnzip(downloadUrl)) {
            log.error("The download and extraction of the release was not successful!");
            updateInProcess = false;
            return;
        }
        File updateDir = new File(tmpUpdateDir);
        ProcessBuilder pb = new ProcessBuilder("/bin/bash", new File(updateDir, this.updateScript).getAbsolutePath(), updateDir.getPath());
        log.info("Starting update process");
        pb.directory(updateDir);
        try {
            log.info("Launching with command: " + String.join((CharSequence)" ", pb.command()));
            pb.redirectOutput(new File(updateDir, "deploy-attempt.log"));
            this.updateProcess = pb.start();
        }
        catch (Exception e) {
            updateInProcess = false;
            log.error("Error in update process", (Throwable)e);
        }
    }

    protected synchronized boolean canStartUpdate() {
        return !this.isUpdateInProcess();
    }

    private synchronized boolean isUpdateInProcess() {
        updateInProcess = this.updateProcess != null && this.updateProcess.isAlive();
        return updateInProcess;
    }

    private boolean downloadAndUnzip(String downloadUrl) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("key", this.key);
        try {
            TarArchiveEntry archiveEntry;
            ByteArrayResource releaseArchive = (ByteArrayResource)new RestTemplate().getForObject(downloadUrl + "?key={key}", ByteArrayResource.class, vars);
            GzipCompressorInputStream compressedArchive = new GzipCompressorInputStream(releaseArchive.getInputStream());
            TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)compressedArchive);
            File baseOutput = new File(tmpUpdateDir);
            baseOutput.mkdirs();
            while ((archiveEntry = archive.getNextTarEntry()) != null) {
                if (archiveEntry.isDirectory()) continue;
                File currentFile = new File(archiveEntry.getName());
                File targetFile = new File(baseOutput, currentFile.getName());
                IOUtils.copy((InputStream)archive, (OutputStream)new FileOutputStream(targetFile));
            }
        }
        catch (RestClientException e) {
            log.warn("Could not retrieve release archive at URL: " + downloadUrl + " Got ", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            log.warn("IO error encountered retrieving input stream or decompressing release archive.", (Throwable)e);
            return false;
        }
        return true;
    }
}

