/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.controller;

import com.netsync.smp.domain.User;
import com.netsync.smp.domain.frontend.PasswordResult;
import com.netsync.smp.domain.frontend.SmpPassword;
import com.netsync.smp.exception.SmpIllegalDataException;
import com.netsync.smp.exception.SmpNotAuthorizedException;
import com.netsync.smp.exception.SmpNotFoundException;
import com.netsync.smp.logic.UserDataFacade;
import com.netsync.smp.web.controller.BaseController;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/users"})
public class UsersController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(UsersController.class);
    protected UserDataFacade userFacade;

    @Autowired
    public UsersController(UserDataFacade userFacade) {
        this.userFacade = userFacade;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public List<User> getAllUsers() {
        return this.userFacade.findAll();
    }

    @RequestMapping(value={"/c/local"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Secured(value={"ROLE_ADMIN"})
    public User createLocalUser(@RequestBody User user) throws SmpIllegalDataException, SmpNotAuthorizedException {
        return this.userFacade.createLocal(user);
    }

    @RequestMapping(value={"/c/ldap"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Secured(value={"ROLE_ADMIN"})
    public User createLdapUser(@RequestBody User user) throws SmpIllegalDataException, SmpNotAuthorizedException {
        return this.userFacade.createLdap(user);
    }

    @RequestMapping(value={"/c/ldapUserCheck"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_ADMIN"})
    public String checkValidLdapUser(@RequestParam String userId) {
        log.info("Ldap User Check Begun For " + userId);
        log.info("I MADE IT INTO CHECKVALIDLDAPUSER");
        boolean exists = this.userFacade.ldapUserExists(userId);
        log.info("Ldap User Check Complete with result: " + userId + " is Ldap = " + exists);
        return "{\"exists\": \"" + exists + "\"}";
    }

    @RequestMapping(value={"/c/ldapUserSearch"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_ADMIN"})
    public List<UserDataFacade.Person> searchLdapUser(@RequestParam String userId) {
        return this.userFacade.searchLdapUser(userId);
    }

    @RequestMapping(value={"/c/ldapUsers"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_ADMIN"})
    public List<UserDataFacade.Person> retrieveAllLdapUsers() {
        return this.userFacade.getAllPersonNames();
    }

    @RequestMapping(value={"/password"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_USER"})
    public PasswordResult changePassword(@RequestBody SmpPassword password) {
        return this.userFacade.changePassword(password);
    }

    @RequestMapping(value={"/rud/{id}/resetPassword"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_ADMIN"})
    public PasswordResult resetPassword(@PathVariable String id) {
        return this.userFacade.resetPassword(id);
    }

    @RequestMapping(value={"/rud/{id}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_ADMIN"})
    public User getUserForId(@PathVariable String id) {
        return this.userFacade.findOneById(id);
    }

    @RequestMapping(value={"/rud/{id}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_ADMIN"})
    public User update(@PathVariable String id, @RequestBody User user) throws SmpIllegalDataException, SmpNotAuthorizedException, SmpNotFoundException {
        return this.userFacade.update(id, user);
    }

    @RequestMapping(value={"/rud/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_ADMIN"})
    public void delete(@PathVariable String id) throws SmpNotAuthorizedException, SmpNotFoundException {
        this.userFacade.delete(id);
    }
}

