/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.security;

import com.netsync.smp.domain.User;
import com.netsync.smp.web.security.SmpRoles;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class CurrentUser {
    private static final String USER_SESSION_ATTR = "currentUser";

    public static void set(User user) {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ra.setAttribute(USER_SESSION_ATTR, (Object)user, 1);
    }

    public static User get() {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        return (User)ra.getAttribute(USER_SESSION_ATTR, 1);
    }

    public static boolean isAdmin() {
        SecurityContext sc = SecurityContextHolder.getContext();
        return sc.getAuthentication().getAuthorities().stream().anyMatch(ga -> SmpRoles.Admin.toString().equals(ga.getAuthority()));
    }
}

