/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.security;

import com.netsync.smp.web.security.SmpActiveDirectoryAuthenticationException;
import com.netsync.smp.web.security.SmpActiveDirectoryLdapAuthenticationProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticationProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SmpActiveDirectoryLdapAuthenticationProvider
extends AbstractLdapAuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(SmpActiveDirectoryLdapAuthenticationProvider.class);
    private static final Pattern SUB_ERROR_CODE = Pattern.compile(".*data\\s([0-9a-f]{3,4}).*");
    private static final int USERNAME_NOT_FOUND = 1317;
    private static final int INVALID_PASSWORD = 1326;
    private static final int NOT_PERMITTED = 1328;
    private static final int PASSWORD_EXPIRED = 1330;
    private static final int ACCOUNT_DISABLED = 1331;
    private static final int ACCOUNT_EXPIRED = 1793;
    private static final int PASSWORD_NEEDS_RESET = 1907;
    private static final int ACCOUNT_LOCKED = 1909;
    private final String domain;
    private final String rootDn;
    private final String url;
    private boolean convertSubErrorCodesToExceptions;
    private String searchFilter = "(&(objectClass=user)(userPrincipalName={0}))";
    private boolean useFqdnForSearch = true;
    ContextFactory contextFactory = new ContextFactory();

    public SmpActiveDirectoryLdapAuthenticationProvider(String domain, String url, String rootDn) {
        Assert.isTrue((boolean)StringUtils.hasText((String)url), (String)"Url cannot be empty");
        this.domain = StringUtils.hasText((String)domain) ? domain.toLowerCase() : null;
        this.url = url;
        this.rootDn = StringUtils.hasText((String)rootDn) ? rootDn.toLowerCase() : null;
    }

    public SmpActiveDirectoryLdapAuthenticationProvider(String domain, String url) {
        Assert.isTrue((boolean)StringUtils.hasText((String)url), (String)"Url cannot be empty");
        this.domain = StringUtils.hasText((String)domain) ? domain.toLowerCase() : null;
        this.url = url;
        this.rootDn = this.domain == null ? null : this.rootDnFromDomain(this.domain);
    }

    public SmpActiveDirectoryLdapAuthenticationProvider(String domain, String url, boolean useFqdnForSearch) {
        this(domain, url);
        this.useFqdnForSearch = useFqdnForSearch;
    }

    protected DirContextOperations doAuthentication(UsernamePasswordAuthenticationToken auth) {
        String username = auth.getName();
        String password = (String)auth.getCredentials();
        log.debug("Root DN:" + this.rootDn);
        DirContext ctx = this.bindAsUser(username, password);
        log.debug("User Authenticated:" + username);
        try {
            DirContextOperations dirContextOperations = this.searchForUser(ctx, username);
            return dirContextOperations;
        }
        catch (NamingException e) {
            log.error("Failed to locate directory entry for authenticated user: " + username, (Throwable)e);
            throw this.badCredentials((Throwable)e);
        }
        finally {
            LdapUtils.closeContext((DirContext)ctx);
        }
    }

    protected Collection<? extends GrantedAuthority> loadUserAuthorities(DirContextOperations userData, String username, String password) {
        String[] groups = userData.getStringAttributes("memberOf");
        if (groups == null) {
            log.debug("No values for 'memberOf' attribute.");
            return AuthorityUtils.NO_AUTHORITIES;
        }
        if (log.isDebugEnabled()) {
            log.debug("'memberOf' attribute values: " + Arrays.asList(groups));
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>(groups.length);
        for (String group : groups) {
            authorities.add(new SimpleGrantedAuthority(new DistinguishedName(group).removeLast().getValue()));
        }
        return authorities;
    }

    private DirContext bindAsUser(String username, String password) {
        String bindUrl = this.url;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        String bindPrincipal = this.createBindPrincipal(username);
        env.put("java.naming.security.principal", bindPrincipal);
        env.put("java.naming.provider.url", bindUrl);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.factory.object", DefaultDirObjectFactory.class.getName());
        try {
            log.debug("bindAsUser:" + username + ":" + bindPrincipal + ":" + bindUrl);
            return this.contextFactory.createContext(env);
        }
        catch (NamingException e) {
            if (e instanceof AuthenticationException || e instanceof OperationNotSupportedException) {
                this.handleBindException(bindPrincipal, e);
                throw this.badCredentials((Throwable)e);
            }
            throw LdapUtils.convertLdapException((NamingException)e);
        }
    }

    private void handleBindException(String bindPrincipal, NamingException exception) {
        int subErrorCode;
        if (log.isDebugEnabled()) {
            log.debug("Authentication for " + bindPrincipal + " failed:" + exception + " FLAG:" + this.useFqdnForSearch);
        }
        if ((subErrorCode = this.parseSubErrorCode(exception.getMessage())) <= 0) {
            log.debug("Failed to locate AD-specific sub-error code in message");
            return;
        }
        log.info("Active Directory authentication failed: " + this.subCodeToLogMessage(subErrorCode));
        if (this.convertSubErrorCodesToExceptions) {
            this.raiseExceptionForErrorCode(subErrorCode, exception);
        }
    }

    private int parseSubErrorCode(String message) {
        Matcher m = SUB_ERROR_CODE.matcher(message);
        if (m.matches()) {
            return Integer.parseInt(m.group(1), 16);
        }
        return -1;
    }

    private void raiseExceptionForErrorCode(int code, NamingException exception) {
        String hexString = Integer.toHexString(code);
        SmpActiveDirectoryAuthenticationException cause = new SmpActiveDirectoryAuthenticationException(hexString, exception.getMessage(), (Throwable)exception);
        switch (code) {
            case 1330: {
                throw new CredentialsExpiredException(this.messages.getMessage("LdapAuthenticationProvider.credentialsExpired", "User credentials have expired"), (Throwable)cause);
            }
            case 1331: {
                throw new DisabledException(this.messages.getMessage("LdapAuthenticationProvider.disabled", "User is disabled"), (Throwable)cause);
            }
            case 1793: {
                throw new AccountExpiredException(this.messages.getMessage("LdapAuthenticationProvider.expired", "User account has expired"), (Throwable)cause);
            }
            case 1909: {
                throw new LockedException(this.messages.getMessage("LdapAuthenticationProvider.locked", "User account is locked"), (Throwable)cause);
            }
        }
        throw this.badCredentials((Throwable)cause);
    }

    private String subCodeToLogMessage(int code) {
        switch (code) {
            case 1317: {
                return "User was not found in directory";
            }
            case 1326: {
                return "Supplied password was invalid";
            }
            case 1328: {
                return "User not permitted to logon at this time";
            }
            case 1330: {
                return "Password has expired";
            }
            case 1331: {
                return "Account is disabled";
            }
            case 1793: {
                return "Account expired";
            }
            case 1907: {
                return "User must reset password";
            }
            case 1909: {
                return "Account locked";
            }
        }
        return "Unknown (error code " + Integer.toHexString(code) + ")";
    }

    private BadCredentialsException badCredentials() {
        return new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.badCredentials", "Bad credentials"));
    }

    private BadCredentialsException badCredentials(Throwable cause) {
        return (BadCredentialsException)this.badCredentials().initCause(cause);
    }

    private DirContextOperations searchForUser(DirContext context, String username) throws NamingException {
        log.debug("Retrieve user details :" + username);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String bindPrincipal = username;
        if (this.useFqdnForSearch) {
            bindPrincipal = this.createBindPrincipal(username);
        }
        log.debug("User searching bindprincipal " + bindPrincipal);
        String searchRoot = this.rootDn != null ? this.rootDn : this.searchRootFromPrincipal(bindPrincipal);
        try {
            String results = SpringSecurityLdapTemplate.searchForSingleEntryInternal((DirContext)context, (SearchControls)searchControls, (String)searchRoot, (String)this.searchFilter, (Object[])new Object[]{bindPrincipal, username}).toString();
            log.debug("User results " + results);
            return SpringSecurityLdapTemplate.searchForSingleEntryInternal((DirContext)context, (SearchControls)searchControls, (String)searchRoot, (String)this.searchFilter, (Object[])new Object[]{bindPrincipal, username});
        }
        catch (IncorrectResultSizeDataAccessException incorrectResults) {
            if (incorrectResults.getActualSize() != 0) {
                throw incorrectResults;
            }
            log.debug("User principal " + bindPrincipal + "' not found in directory");
            UsernameNotFoundException userNameNotFoundException = new UsernameNotFoundException("User " + bindPrincipal + " not found in directory.", (Throwable)incorrectResults);
            throw this.badCredentials((Throwable)userNameNotFoundException);
        }
    }

    private String searchRootFromPrincipal(String bindPrincipal) {
        int atChar = bindPrincipal.lastIndexOf(64);
        if (atChar < 0) {
            log.debug("User principal '" + bindPrincipal + "' does not contain the domain, and no domain has been configured");
            throw this.badCredentials();
        }
        return this.rootDnFromDomain(bindPrincipal.substring(atChar + 1, bindPrincipal.length()));
    }

    private String rootDnFromDomain(String domain) {
        String[] tokens = StringUtils.tokenizeToStringArray((String)domain, (String)".");
        StringBuilder root = new StringBuilder();
        for (String token : tokens) {
            if (root.length() > 0) {
                root.append(',');
            }
            root.append("dc=").append(token);
        }
        return root.toString();
    }

    String createBindPrincipal(String username) {
        if (this.domain == null || username.toLowerCase().endsWith(this.domain)) {
            return username;
        }
        return username + "@" + this.domain;
    }

    public void setConvertSubErrorCodesToExceptions(boolean convertSubErrorCodesToExceptions) {
        this.convertSubErrorCodesToExceptions = convertSubErrorCodesToExceptions;
    }

    public void setSearchFilter(String searchFilter) {
        Assert.hasText((String)searchFilter, (String)"searchFilter must have text");
        this.searchFilter = searchFilter;
    }
}

