/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.security;

import com.netsync.smp.domain.HashedPassword;
import com.netsync.smp.domain.User;
import com.netsync.smp.logic.ApplicationUserPermissionsDataFacade;
import com.netsync.smp.logic.UserDataFacade;
import com.netsync.smp.web.security.PasswordEncoder;
import com.netsync.smp.web.security.SmpActiveDirectoryLdapAuthenticationProvider;
import com.netsync.smp.web.security.SmpRoles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SmpAuthenticationManager
implements AuthenticationManager {
    private static final Logger log = LoggerFactory.getLogger(SmpAuthenticationManager.class);
    @Value(value="${users.system_admin.username}")
    protected String username;
    @Value(value="${users.system_admin.password}")
    protected String password;
    @Value(value="${ldap.domain}")
    protected String ldapDomain;
    @Value(value="${ldap.hostname}")
    protected String ldapHostname;
    @Value(value="${ldap.port}")
    protected String ldapPort;
    @Value(value="${ldap.searchFilter:}")
    protected String ldapSearchFilter;
    @Value(value="${ldap.useFqdnForSearch:}")
    protected String useFqdnForSearch;
    @Value(value="${ldap.disabled:false}")
    protected boolean ldapDisabled;
    protected UserDataFacade userFacade;
    protected ApplicationUserPermissionsDataFacade permissionFacade;
    protected SmpActiveDirectoryLdapAuthenticationProvider provider;

    @Autowired
    public SmpAuthenticationManager(UserDataFacade userFacade, ApplicationUserPermissionsDataFacade permissionFacade) {
        this.userFacade = userFacade;
        this.permissionFacade = permissionFacade;
    }

    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        log.info("User trying auth: " + auth.getPrincipal().toString());
        User user = this.userFacade.findOneByUserId(auth.getPrincipal().toString());
        if (null != user && (this.isValidSmpUser(auth, user) || !this.ldapDisabled && this.isValidLdapUser(auth))) {
            ArrayList<SimpleGrantedAuthority> perms = new ArrayList<SimpleGrantedAuthority>();
            perms.add(new SimpleGrantedAuthority(SmpRoles.User.toString()));
            if (user.isAdmin()) {
                perms.add(new SimpleGrantedAuthority(SmpRoles.Admin.toString()));
            }
            if (this.permissionFacade.getHasEditPermissions(user)) {
                perms.add(new SimpleGrantedAuthority(SmpRoles.Supervisor.toString()));
            }
            return new UsernamePasswordAuthenticationToken(auth.getPrincipal(), auth.getCredentials(), perms);
        }
        throw new BadCredentialsException("Invalid username / password");
    }

    public SmpActiveDirectoryLdapAuthenticationProvider authProvider() {
        if (null == this.provider) {
            if (this.ldapDisabled) {
                log.debug("authProvider: LDAP is disabled.");
                return null;
            }
            log.debug("User finding in authProvider " + this.useFqdnForSearch + "search filter:" + this.ldapSearchFilter);
            this.provider = new SmpActiveDirectoryLdapAuthenticationProvider(this.ldapDomain, "ldap://" + this.ldapHostname + ":" + this.ldapPort.toString() + "/", !"false".equalsIgnoreCase(this.useFqdnForSearch));
            this.provider.setUseAuthenticationRequestCredentials(true);
            if (StringUtils.hasText((String)this.ldapSearchFilter)) {
                log.info("Overriding default AD search filter with " + this.ldapSearchFilter);
                this.provider.setSearchFilter(this.ldapSearchFilter);
            }
        }
        return this.provider;
    }

    public boolean isValidLdapUser(Authentication auth) {
        try {
            if (this.ldapDisabled) {
                log.debug("isValidLdapUser: LDAP is disabled.");
                return false;
            }
            log.debug("User trying to authenticate ldap " + auth.getPrincipal().toString());
            Authentication attempt = this.authProvider().authenticate(auth);
            boolean isAuthenticated = attempt.isAuthenticated();
            return isAuthenticated;
        }
        catch (Exception e) {
            log.error("isValidLdapUser: authenticate threw exception: ", (Throwable)e);
            return false;
        }
    }

    protected boolean isValidSmpUser(Authentication auth, User user) {
        if (!(null != auth && null != user && null != auth.getPrincipal() && StringUtils.hasText((String)auth.getPrincipal().toString()) && null != auth.getCredentials() && StringUtils.hasText((String)auth.getCredentials().toString()) && null != user.getHashedPassword() && StringUtils.hasText((String)user.getHashedPassword().getHash()))) {
            log.info("Person is not a smp internal db user: " + auth.getPrincipal().toString());
            return false;
        }
        log.info("User fund in smp db: " + auth.getPrincipal().toString());
        return auth.getPrincipal().toString().equals(user.getUserId()) && PasswordEncoder.matches((String)auth.getCredentials().toString(), (HashedPassword)user.getHashedPassword());
    }
}

