/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.security;

import com.netsync.smp.domain.User;
import com.netsync.smp.logic.UserDataFacade;
import com.netsync.smp.web.security.CurrentUser;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class SmpUserFilter
extends GenericFilterBean {
    @Autowired
    protected UserDataFacade userFacade;
    protected static final Log LOG = LogFactory.getLog(SmpUserFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (CurrentUser.get() == null) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (auth != null && !(auth instanceof AnonymousAuthenticationToken) && auth.isAuthenticated()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Database User not in session. Attempting to load " + auth.getPrincipal().toString()));
                }
                User user = this.userFacade.findOneByUserId(auth.getPrincipal().toString());
                CurrentUser.set((User)user);
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Database User " + CurrentUser.get().getUserId() + " found on session"));
        }
        chain.doFilter(request, response);
    }
}

