/*
 * Decompiled with CFR 0.152.
 */
package com.netsync.smp.web.security;

import com.netsync.smp.dao.UserRepository;
import com.netsync.smp.domain.HashedPassword;
import com.netsync.smp.domain.User;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SystemAdministrator {
    @Value(value="${users.system_admin.username}")
    protected String username;
    @Value(value="${users.system_admin.password}")
    protected String password;
    protected UserRepository userRepo;

    @Autowired
    public SystemAdministrator(UserRepository userRepo) {
        this.userRepo = userRepo;
    }

    @PostConstruct
    protected void makeUser() {
        User existing = this.userRepo.findOneByUserId(this.username);
        if (null == existing) {
            User created = new User(this.username, true, false);
            created.setHashedPassword(HashedPassword.fromClear((String)this.password));
            this.userRepo.insert(created);
        } else {
            existing.setAdmin(true);
            existing.setHashedPassword(HashedPassword.fromClear((String)this.password));
            this.userRepo.save(existing);
        }
    }
}

